// AttachSpec ("../mgrp.spec");

/* file to test most code in CompTree */
// takes about 150 seconds 

// test if the series of subgroups is a normal series
IsNormalSeries := function (series) 

    topDown := Reverse(series);
    RandomSchreier(topDown[1]);
    Verify(topDown[1]);

    for i in [1 .. #topDown - 1] do
	if not topDown[i + 1] subset topDown[i] then
	    str := Sprintf("%o not subgroup of %o",
		topDown[i + 1], topDown[i]);
	    return false;
	end if;
	
	if not IsNormal(topDown[i], topDown[i + 1]) then
	    str := Sprintf("%o not normal in %o",
		topDown[i + 1], topDown[i]);
	    return false;
	end if;
    end for;

    return true;
end function;

SetEchoInput (true);

 G := GL(2, 3);
 S := Sym(3);
 G := TensorWreathProduct(G, S);
 IsTensorInduced(G);
 TensorInducedPermutations(G);
 C := TensorInducedBasis(G);
 x := G.1^C;
 x;

 IsProportional(x, 2);

 IsProportional(x, 4);

 K<w> := GF(5, 7);
 G := 
 MatrixGroup<6, GF(5, 7) |
 [w^19035, w^14713, w^50617, w^14957, w^51504, w^48397, w^16317, w^3829,
  w^35189, w^2473, w^19497, w^77192, w^46480, w^6772, w^29577, w^61815,
  w^54313, w^16757, w^43765, w^64406, w^58788, w^30789, w^13579, w^66728,
  w^7733, w^45434, w^42411, w^61613, w^12905, w^6889, w^50116, w^16117,
  w^56717, w^25226, w^49940, w^36836 ],
 [w^63955, w^40568, w^45004, w^11642, w^39536, w^11836, w^52594, w^71166,
  w^47015, w^74450, w^32373, w^37021, w^76381, w^18155, w^57943, w^31194,
  w^62524, w^65864, w^11868, w^76867, w^26483, w^41335, w^64856, w^41125,
  w^43990, w^40104, w^24842, w^3153, w^23777, w^60024, w^14454, w^68648,
  w^43403, w^26710, w^39779, w^22074 ] >;
 flag, phi, tau, gamma, delta := RecogniseSL2(G, 5^7);
 phi;
 g := Random(G);
 h := phi (g);
 h;
 k := tau(h);
 w := gamma(k);
 m := delta(w);
 IsScalar(m * g^-1);
 H := SL(2, 5^7);
 h := H![1,1,0,1];
 g := tau(h);
 Order(g);
 g := Random(GL(6, 5^7));
 SL2ElementToWord(G, g);
 SatisfiesSL2Presentation (G, 5^7);
 SatisfiesSL2Presentation (G, 5^7: Projective:=true);

G:= SL (3, 2^2);
T := FrobeniusImage (G, 1);
K := TensorProduct (G, T);
M:=GModule (K);
S := SymmetricSquare (M);
CF :=CompositionFactors (S);
G := ActionGroup (Rep (CF));
flag := IsTensor (G);
assert flag;
factors := TensorFactors (G);
AreProportional ([factors[1].i : i in [1..Ngens (factors[1])]], 3);
H := factors[1];
flag,a,b,c,d:=RecogniseSL3 (H, 2^2);
for i in [1..10] do
x:=Random (H);
assert IsScalar (b (a (x)) * x^-1) ;
assert IsScalar (d (c (x)) * x^-1) ;
end for;


G:=MatrixGroup<10, GF(5, 4) |
    [ W^3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, W, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, W^2, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, W^623, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, W, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, W^621, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, W^622, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, W^623, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1 ] where W := GF(5, 4).1,
    [ 4, 0, 3, 0, 0, 2, 0, 0, 0, 1, 4, 0, 2, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 2,
    0, 0, 0, 4, 0, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1, 0, 0, 0, 0, 0, 
    0, 0, 0, 4, 0, 0, 0, 1, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0 ] 
    where W := GF(5, 4).1 >
;
flag,a,b,c,d:=RecogniseSL3 (G, 5^4);
for i in [1..10] do
"test ", i;
x:=Random (G);
assert IsScalar (Function (b) (Function (a) (x)) * x^-1) ;
assert IsScalar (d (c (x)) * x^-1) ;
end for;


 G := Sz(32);
 G ^:= Random(Generic(G));
 flag, q := SuzukiRecognition(G);
 flag, q eq 32;
 flag, iso, inv, g2slp, slp2g := RecognizeSz(G);
 flag;
 iso, inv;
 w := Function(g2slp)(G.1);
 #w;
 ww := Function(g2slp)(G.1);
 w eq ww;
 W := WordGroup(G);
 NumberOfGenerators(Parent(w)), NumberOfGenerators(W);
 flag, ww := IsCoercible(W, w);
 flag;
 slp2g(w) eq Evaluate(ww, UserGenerators(G));
 flag, ww := SzElementToWord(G, G.1);
 flag, slp2g(w) eq slp2g(ww);
 H := Sp(4, 32);
 flag, ww := SzElementToWord(G, H.1);
 flag;
 // in this case we will not get an SLP
 ww := Function(g2slp)(H.1);
 ww;
 SatisfiesSzPresentation(G);

 F := GF(2, 9);
 twists := [0, 3, 6];
 G := SuzukiIrreducibleRepresentation(F, twists);
 Degree(G), IsAbsolutelyIrreducible(G);
 G ^:= Random(Generic(G));
 flag, GG := IsOverSmallerField(G);
 flag, CoefficientRing(GG);
 time SuzukiRecognition(GG);
 time flag, iso, inv, g2slp, slp2g := RecogniseSz(GG);
 iso;
 R := RandomProcess(GG);
 g := Random(R);
 time w := Function(g2slp)(g);
 // but SLP evaluation is harder in large dimensions
 time slp2g(w) eq g;
 time SatisfiesSzPresentation(GG);

 G := Sz(8);
 _, P := SuzukiPermutationRepresentation(G);
 // for example over GF(9)
 M := PermutationModule(P, GF(3, 2));
 factors := CompositionFactors(M);
 exists(m64){f : f in factors | Dimension(f) eq 64};
 m64;
 H := ActionGroup(m64);
 IsAbsolutelyIrreducible(H);
 flag, G := IsOverSmallerField(H);
 Degree(G), CoefficientRing(G);
 time flag, iso, inv, g2slp, slp2g := RecogniseSz(G);
 iso;
 R := RandomProcess(G);
 g := Random(R);
 time w := Function(g2slp)(g);
 time slp2g(w) eq g;
 time SatisfiesSzPresentation(G);

// Let's try a Suzuki group in cross characteristic
G := Sz(8);
_, P := SuzukiPermutationRepresentation(G);

// for example over GF(9)
M := PermutationModule(P, GF(3, 2));
factors := Sort(CompositionFactors(M), func<x, y | Dimension(x) - Dimension(y)>);
H := ActionGroup(factors[2]);

// we actually end up with a group over GF(3)
print IsAbsolutelyIrreducible(H);
flag, G := IsOverSmallerField(H);
print Degree(G), CoefficientRing(G);

// constructive recognition is easy in this case
time flag, iso, inv, g2slp, slp2g := RecogniseSz(G);
print iso;

// as well as constructive membership
R := RandomProcess(G);
g := Random(R);
time w := Function(g2slp)(g);
time print slp2g(w) eq g;

// we still have a Suzuki group
time print SatisfiesSzPresentation(G);

// let's try a small field
m := 1;
F := GF(3, 2 * m + 1);
q := #F;
print q;
G := Ree(F);

// let's try a conjugate
G ^:= Random(Generic(G));

// also move to another generating set
G := DerivedGroupMonteCarlo(G);
print NumberOfGenerators(G);

// First we must recognise the group
time flag, iso, inv, g2slp, slp2g := RecogniseRee(G);

// let's try a small field
m := 1;
F := GF(3, 2 * m + 1);
q := #F;
print q;
G := Ree(F);

// let's try a conjugate
G ^:= Random(Generic(G));

// also move to another generating set
G := DerivedGroupMonteCarlo(G);
print NumberOfGenerators(G);

// first we must recognise the group
time flag, iso, inv, g2slp, slp2g := RecogniseRee(G);

// try finding the maximal subgroups
time l, slps := ReeMaximalSubgroups(G);

// should have a parabolic, an involution centraliser, three Frobenius groups
print #l;

// we can conjugate all except Frobenius groups
// but verifying the conjugating element can be expensive
r := Random(G`RandomProcess);
time g, slp := ReeMaximalSubgroupsConjugacy(G, l[1], l[1]^r);
time print l[1]^g eq l[1]^r;

time g, slp := ReeMaximalSubgroupsConjugacy(G, l[2], l[2]^r);
print l[2]^g eq l[2]^r;


MySymmetricPower := function (G, n)
   M:=GModule (G);
   A := SymmetricPower (M, n);
   return ActionGroup (A);
end function;

GammaLMatrix := function (x, n)

   G := Parent (x);
   G := GL (Degree (G), BaseRing (G));
   e := Eltseq (x);
   ee := [y^n : y in e];
   return G!ee;
     
end function;

TwistedSymmetricPower := function (G, s, f)
   d := Degree (G);
   F := BaseRing (G);
   p := Characteristic (F);
   M := GModule (G);
   S := SymmetricPower (M, s);
   S := ActionGroup (S);
   Gens := [S.i : i in [1..Ngens (G)]];
   Twisted := [GammaLMatrix (Gens[i], p^f) : i in [1..#Gens]];
   return sub <GL (Degree (S), F) | Twisted>;
end function;
 
/* tensor product of twisted symmetric powers defined
   over GF (p^e); s lists the symmetric powers,
   f is the twisting via powers of the Frobenius 
   automorphism to be applied to each symmetric power */

SymmetricPowerExample := function (p, e, s, f: Tensor := true)

   F := GF (p, e);
   L := SL (2, F);
   G := TwistedSymmetricPower (L, s[1], f[1]);

   if Tensor eq false then return G; end if;

   for i in [2..#s] do 
      T2 := TwistedSymmetricPower (L, s[i], f[i]);
      G := sub <GL (Degree (G) * Degree (T2), F ) | 
                 [TensorProduct (G.i, T2.i): i in [1..Ngens (G)]]>;
   end for;

   return G;

end function;

K<w> := GF(5, 7);
G := 
  MatrixGroup<6, GF(5, 7) |
  [w^19035, w^14713, w^50617, w^14957, w^51504, w^48397, w^16317, w^3829,
   w^35189, w^2473, w^19497, w^77192, w^46480, w^6772, w^29577, w^61815,
   w^54313, w^16757, w^43765, w^64406, w^58788, w^30789, w^13579, w^66728,
   w^7733, w^45434, w^42411, w^61613, w^12905, w^6889, w^50116, w^16117,
   w^56717, w^25226, w^49940, w^36836 ],
  [w^63955, w^40568, w^45004, w^11642, w^39536, w^11836, w^52594, w^71166,
   w^47015, w^74450, w^32373, w^37021, w^76381, w^18155, w^57943, w^31194,
   w^62524, w^65864, w^11868, w^76867, w^26483, w^41335, w^64856, w^41125,
   w^43990, w^40104, w^24842, w^3153, w^23777, w^60024, w^14454, w^68648,
   w^43403, w^26710, w^39779, w^22074 ] >;
time flag, phi, tau, gamma, delta := RecogniseSL2(G, 5^7);
for i in [1..10] do 
g := Random ((G));
assert IsScalar (g^-1 * tau (phi (g)));
end for;

 p := 5;
 e := 4;
 s := [2, 3];
 f := [0,1];
 G := SymmetricPowerExample (p, e, s, f);
 G := RandomConjugate (G);
 time flag,a,b,c,d := RecogniseSL2 (G);
for i in [1..10] do
g:=Random (G);
assert IsScalar (b (a (g)) * g^-1);
assert IsScalar (d (c (g)) * g^-1);
i;
end for;


 p := 3;
 e := 10;
 s := [2, 2, 2];
 f := [0,1,2];
 G := SymmetricPowerExample (p, e, s, f);
 G := RandomConjugate (G);
 time flag,a,b,c,d  := RecogniseSL2 (G, p^e);
for i in [1..10] do
g:=Random (G);
assert IsScalar (b (a (g)) * g^-1);
assert IsScalar (d (c (g)) * g^-1);
i;
end for;


for d in [4..10 by 2] do
   for q in [2, 3,4,5,7,8,9] do
       G := SOPlus (d, q);
       flag := RecogniseClassical (G);
       assert flag;
       assert ClassicalType (G) eq "orthogonalplus";
   end for;
end for;

for d in [4..10 by 2] do
   for q in [2, 3,4,5,7,8,9] do
       G := Sp (d, q);
       G := RandomConjugate (G);
       flag := RecogniseClassical (G : NumberOfElements := 500);
       assert flag;
       assert ClassicalType (G) eq "symplectic";
   end for;
end for;

name := "L35";
    A := ATLASGroup (name);
    n := #MatRepKeys (A);
    for i in [1..n] do 
        G := MatrixGroup(name, i);
        p := LieCharacteristic (G);
        assert Type (p) eq RngIntElt;
        flag, n := LieType (G, p);
       n;
        assert n eq <"A", 2, 5>;
    end for;

name := "S44";
    A := ATLASGroup (name);
    n := #MatRepKeys (A);
    for i in [1..n] do 
        G := MatrixGroup(name, i);
        p := LieCharacteristic (G);
        assert Type (p) eq RngIntElt;
        flag, n := LieType (G, p);
        n;
       assert n eq <"C", 2, 4>;
    end for;


F:=GF(9);
P:=GL(32,F);
w := PrimitiveElement(F);
g1:=P![ 1,w^6,1,0,w^6,w^2,w^2,0,2,1,0,w^2,w^2,0,0,1,
0,2,2,0,0,w^6,0,0,2,0,0,0,w^6,0,0,0,w^2,1,w^6,0,1,2,1,0,w^6,w^2,0,1,1,0,0,
w^2,0,w^2,w^2,0,0,1,0,0,w^2,0,0,0,2,0,0,0,
w^2,1,w^6,0,1,1,1,0,w^6,w^6,0,1,2,0,0,w^6,0,w^2,w^6,0,0,2,0,0,w^6,0,0,0,1,0,0,0,
1,w^2,1,0,w^2,w^2,w^6,0,2,2,0,w^6,w^2,0,0,2,0,2,1,0,0,w^6,0,0,1,0,0,0,w^6,0,0,0,
0,0,0,1,0,0,0,w^6,0,0,1,0,0,w^6,w^2,0,w^2,0,0,2,1,0,w^2,w^2,0,1,2,2,0,w^6,2,w^6,
w^2,2,w^2,0,1,2,1,0,w^2,w^6,0,2,2,0,0,w^2,0,w^2,w^2,0,0,2,0,0,w^6,0,0,0,2,0,0,0,
2,w^2,2,0,w^2,w^2,w^6,0,1,1,0,w^6,w^2,0,0,1,0,1,2,0,0,w^6,0,0,2,0,0,0,w^6,0,0,0,
w^6,1,w^2,0,1,1,1,0,w^2,w^2,0,1,2,0,0,w^2,0,w^6,w^2,0,0,2,0,0,w^2,0,0,0,1,0,0,0,
0,0,0,w^2,0,0,0,1,0,0,w^6,0,0,1,2,0,1,0,0,w^6,w^2,0,1,1,0,w^2,w^2,w^2,0,1,w^2,2,
2,w^6,1,0,w^2,w^6,w^6,0,2,1,0,w^2,w^2,0,0,2,0,1,1,0,0,w^6,0,0,2,0,0,0,w^2,0,0,0,
w^6,1,w^2,0,1,2,1,0,w^2,w^6,0,1,1,0,0,w^6,0,w^6,w^6,0,0,1,0,0,w^6,0,0,0,2,0,0,0,
0,0,0,w^2,0,0,0,1,0,0,w^6,0,0,1,1,0,1,0,0,w^6,w^6,0,1,2,0,w^6,w^2,w^6,0,2,w^6,1,
1,w^2,2,0,w^6,w^6,w^2,0,1,1,0,w^6,w^2,0,0,2,0,2,1,0,0,w^6,0,0,2,0,0,0,w^2,0,0,0,
0,0,0,1,0,0,0,w^2,0,0,1,0,0,w^2,w^2,0,w^6,0,0,2,2,0,w^6,w^2,0,2,2,1,0,w^6,1,w^6,
w^2,1,w^2,0,2,2,2,0,w^2,w^2,0,1,2,0,0,w^6,0,w^2,w^6,0,0,2,0,0,w^2,0,0,0,2,0,0,0,
0,0,0,w^2,0,0,0,2,0,0,w^2,0,0,1,2,0,1,0,0,w^2,w^6,0,2,2,0,w^2,w^2,w^2,
0,2,w^6,2,2,w^6,2,0,w^6,w^2,w^2,0,1,2,0,w^2,w^2,
0,0,2,0,1,1,0,0,w^6,0,0,1,0,0,0,w^6,0,0,0,0,0,0,2,0,0,0,w^2,0,0,2,0,0,w^2,w^2,0,
w^6,0,0,1,1,0,w^6,w^2,0,1,1,2,0,w^6,2,w^6,
w^2,2,w^2,0,1,1,1,0,w^2,w^2,0,2,1,0,0,w^6,0,w^2,w^6,0,0,1,0,0,w^2,0,0,0,1,0,0,0,
0,0,0,w^6,0,0,0,1,0,0,w^2,0,0,1,1,0,1,0,0,w^2,w^2,0,1,2,0,w^2,w^6,w^2,0,2,w^2,1,
1,w^6,2,0,w^2,w^2,w^6,0,1,1,0,w^2,w^6,0,0,2,0,2,1,0,0,w^2,0,0,2,0,0,0,w^6,0,0,0,
0,0,0,2,0,0,0,w^6,0,0,1,0,0,w^2,w^6,0,w^6,0,0,2,1,0,w^2,w^2,0,2,1,1,0,w^6,2,w^2,
0,0,0,w^6,0,0,0,1,0,0,w^2,0,0,1,2,0,1,0,0,w^2,w^6,0,1,1,0,w^6,w^6,w^6,0,1,w^6,2,
2,w^2,1,0,w^6,w^2,w^2,0,2,1,0,w^6,w^6,0,0,2,0,1,1,0,0,w^2,0,0,2,0,0,0,w^6,0,0,0,
0,0,0,1,0,0,0,w^2,0,0,2,0,0,w^6,w^6,0,w^2,0,0,1,1,0,w^6,w^2,0,2,2,1,0,w^6,2,w^2,
0,0,0,w^2,0,0,0,1,0,0,w^2,0,0,2,2,0,2,0,0,w^2,w^2,0,1,2,0,w^6,w^2,w^6,0,2,w^2,2,
0,0,0,2,0,0,0,w^6,0,0,2,0,0,w^6,w^2,0,w^2,0,0,1,2,0,w^2,w^2,0,2,1,1,0,w^6,1,w^6,
w^2,1,w^2,0,2,1,2,0,w^2,w^6,0,1,1,0,0,w^2,0,w^2,w^2,0,0,1,0,0,w^6,0,0,0,1,0,0,0,
0,0,0,w^2,0,0,0,2,0,0,w^2,0,0,1,1,0,1,0,0,w^2,w^2,0,2,1,0,w^6,w^2,w^6,0,1,w^2,1,
0,0,0,1,0,0,0,w^6,0,0,2,0,0,w^2,w^2,0,w^6,0,0,1,1,0,w^2,w^6,0,2,2,1,0,w^2,2,w^6,
0,0,0,2,0,0,0,w^2,0,0,1,0,0,w^6,w^2,0,w^2,0,0,2,1,0,w^6,w^6,0,2,1,1,0,w^2,2,w^6,
0,0,0,w^2,0,0,0,1,0,0,w^2,0,0,2,1,0,
2,0,0,w^2,w^6,0,1,1,0,w^2,w^2,w^2,0,1,w^6,1];
g2:=P![1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 ];
gens := [g1,g2];
G := sub<P| gens>;
G := RandomConjugate (G);
flag := IsExtraSpecialNormaliser (G);
flag;
assert flag;

// Field increased to GF(9) - this makes it imprimitive.
F := GF(9);
P:=GL(20,F);
g1:=P![
 0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1];
g2 := P![
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
 0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0]; 
g3 := P![
 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1]; 
gens := [g1,g2,g3];
G := sub < P | gens >;
G := RandomConjugate (G);
flag := IsPrimitive (G);
assert flag eq false;
B := BlocksImage (G);
assert #B eq 2; 

F:=GF(2);
MG:=GL(3,F);
PG:=Sym(3);
G:=TensorWreathProduct(MG,PG);
G:= RandomConjugate (G);
flag := IsTensorInduced (G);
flag;
assert flag;

//This is equal to Gammal(10,8^5).
F:=GF(8);
P:=GL(50,F);
w := PrimitiveElement(F);
g1:=P![
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,w^4,w^5,0,w^5,w^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1];
g2:=P![
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0];
g3:=P![
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,0,w,1,w,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,w^3,0,w,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
w^3,w^3,w^2,w^6,w^6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,0,w,1,w,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,w^3,0,w,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,w^3,w^3,w^2,w^6,w^6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,w^3,0,w,1,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^5,w^5,w^2,w^6,w^4,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,w^3,0,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,w^3,w^2,w^6,w^6,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,
0,w,1,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
0,w^3,0,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,w^3,w^2,w^6,w^6,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,0,w,1,w,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,w^3,0,w,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,w^3,w^3,w^2,w^6,w^6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,w^3,0,w,1,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^5,w^5,w^2,w^6,w^4,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,0,w^3,0,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,w^3,w^2,w^6,w^6,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,0,
w,1,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
w^3,0,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,w^3,w^2,w^6,w^6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,0,w,1,w,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,w^3,0,w,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,w^3,w^3,w^2,w^6,w^6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,w^3,0,w,1,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,0,w^3,0,w,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,w^3,w^2,w^6,w^6,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,0,w,1,w,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,w^5,w^5,w^2,w^6,w^4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,w^3,0,w,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,w^3,w^3,w^2,w^6,w^6];
gens := [g1,g2,g3];
G := sub < P | gens >;
G := RandomConjugate (G);

flag := IsSemiLinear (G);
flag;
assert flag;

F:=GF(5);
MG1:=GL(5,F);
MG2:=GL(3,F);
P:=GL(15,F);
A1:=MatrixAlgebra(F,5);
A2:=MatrixAlgebra(F,3);
g1:=A1!MG1.1; g2:=A1!MG1.2; g3:=A1!Identity(MG1);
h1:=A2!MG2.1; h2:=A2!MG2.2; h3:=A2!Identity(MG2);
w:=TensorProduct(g1,h3);
x:=TensorProduct(g2,h3);
y:=TensorProduct(g3,h1);
z:=TensorProduct(g3,h2);
gens := [ P!w,P!x,P!y,P!z ];
G:=sub< P | gens >;
G := RandomConjugate (G);
flag := IsTensor (G);
flag;
assert flag;


F := GF(2, 7);
G := LargeRee(F);
G ^:= Random(Generic(G));

// perform non-constructive recognition
flag, q := LargeReeRecognition(G);
print flag, q eq #F;

// perform constructive recognition
time flag, iso, inv, g2slp, slp2g := RecognizeLargeRee(G);
print flag;

// the explicit isomorphisms are defined by rules
print iso, inv;

// so we can use Function to avoid Magma built-in membership testing
// we might not obtain the shortest possible SLP
time w := Function(g2slp)(G.1);
print #w;

// and the algorithm is probabilistic, so different executions will most
// likely give different results
time ww := Function(g2slp)(G.1);
print w eq ww;

// the resulting SLPs are from another word group
W := WordGroup(G);
print NumberOfGenerators(Parent(w)), NumberOfGenerators(W);

// but can be coerced into W
flag, ww := IsCoercible(W, w);
print flag;

// so there are two ways to get the element back
print slp2g(w) eq Evaluate(ww, UserGenerators(G));

// an alternative is this intrinsic, which is better if the elements are not
// known to lie in the group
time flag, ww := LargeReeElementToWord(G, G.1);
print flag, slp2g(w) eq slp2g(ww);

// let's try something just outside the group
H := ChevalleyGroup("F", 4, 128);
time flag, ww := LargeReeElementToWord(G, H.1);
print flag;

// in this case we will not get an SLP
time ww := Function(g2slp)(H.1);

// let's try a small field
F := GF(2, 5);
G := LargeRee(F);
q := #F;
print q;

// let's try a conjugate
G ^:= Random(Generic(G));

// also move to another generating set
G := DerivedGroupMonteCarlo(G);
print NumberOfGenerators(G);

// first we must recognise the group
time flag, iso, inv, g2slp, slp2g := RecogniseLargeRee(G);

// try creating some Sylow subgroups
p := Random({x[1] : x in Factorization(q^2 - q + 1)} diff
    {x[1] : x in Factorization(q + 1)});
print p;
time R := LargeReeSylow(G, p);

// those Sylow subgroups are cyclic, and we know the order
print #R, NumberOfGenerators(R);

// creating Sylow 2-subgroups is harder, since there are lots of generators
time R := LargeReeSylow(G, 2);

// other examples of Sylow subgroups
p := Random([x[1] : x in Factorization(q - 1)]);
print p;
time R := LargeReeSylow(G, p);

// these are not cyclic and have order p^2
print NumberOfGenerators(R), #R;

G := ChevalleyGroup ("2F", 4, 8);
G := RandomConjugate (G);
flag, a, b,c, d:=RecogniseLargeRee (G);
for i in [1..10] do
i;
g:=Random (G);
time assert IsScalar (Function (b) (Function (a)(g)) * g^-1);
time assert IsScalar (d(Function (c) (g)) * g^-1);
end for;


// Convert input parameters
// Verbose := StringToInteger(Verbose);
// nMemberships := StringToInteger(nMemberships);
Verbose := 1;
nMemberships := 50;


// Convert to boolean
// VerifySeries := eval("StringToInteger(VerifySeries) gt 0");
// Verify := eval("StringToInteger(Verify) gt 0");
// Series := eval("StringToInteger(Series) gt 0");
VerifySeries := false;
Verify := true;
Series := true;


SetVerbose("CompositionTree", Verbose);
if Verbose ge 8 then
    SetVerbose("RandomSchreier", 1);
    SetVerbose("STCS", 1);
    SetVerbose("C6", 1);
    SetVerbose("ClassicalRecognition", 1);
end if;

if Verbose ge 10 then
    SetVerbose("sl2q", 1);
    SetVerbose("sl3q", 1);
    SetVerbose("Exceptional", 1);
    SetVerbose("Smash", 1);
    SetVerbose("Tensor", 1);
    SetVerbose("TensorInduced", 1);
    SetVerbose("SmallerField", 1);
    SetVerbose("Classical", 1);
    SetVerbose("Identify", 1);
    SetVerbose("Characteristic", 1);
end if;

procedure ErrorOutput(err, name, G)
    print "Error in", name;
    print "Error message:", err`Object;
    print err`Position;

    print "Bad group:";
    print G : Magma;
end procedure;

// Get composed Function on a composition of Maps    
function getMapFunction(mapping)
    local f;

    f := func<x | x>;
    for g in Components(mapping) do
	f := func<x | Function(g)(f(x))>;
    end for;

    return f;
end function;

procedure TestGroup(G)
    try
	t := Cputime();
        tree := CompositionTree(G : Verify := false);
	//print "Time:", Cputime(t);
    catch err
	ErrorOutput(err, "CompositionTree", G);
	return;
    end try;

    try
	if CompositionTreeFastVerification(G) and Verify then
	    flag := CompositionTreeVerify(G);
	    assert flag;
	end if;
    catch err
	ErrorOutput(err, "CompositionTreeVerify", G);
        return;
    end try;
		
    R := RandomProcess(G);
    
    // Input word group
    W, slpEval := WordGroup(G);
    
    // Nice word group
    WN, slpEvalN := CompositionTreeSLPGroup(G);
    
    // Nice to user SLPs
    WN2W := CompositionTreeNiceToUser(G);
    
    slpLen := [];

    try		
	// Do some membership testing
        for i in [1 .. nMemberships] do
	    g := Random(R);
		
	    flag, slp := CompositionTreeElementToWord(G, g);
	    assert flag;
	    
	    assert Parent(slp) cmpeq WN;
	    assert slpEvalN(slp) eq g;
	    assert slpEval(WN2W(slp)) eq g;
	    
	    Append(~slpLen, [#slp, #WN2W(slp)]);
	end for;
	    
	//print "Nice SLP Len, User SLP Len";
	//print Matrix(Integers(), slpLen);
    catch err
	ErrorOutput(err, "CompositionTreeElementToWord", G);
        return;
    end try;
    
    try
	if Series then
	    series, toFactor, fromFactor, factor2slp :=
		CompositionTreeSeries(G);

	    if VerifySeries then
		flag := IsNormalSeries(series);
		assert flag;
	    end if;
	end if;
    catch err
	ErrorOutput(err, "CompositionTreeSeries", G);
    end try;
    
    if Series then
// error "HERE WE ARE", Series;
	try
"HERE WE ARE";
// error "HERE k = ", #toFactor,nMemberships;
	    for i in [1 .. #toFactor] do
"****** PROCESS I = ", i;
	        H := Codomain(toFactor[i]);
	        S := RandomProcess(H);
		W := WordGroup(H);
		
		for k in [1 .. nMemberships] do
"****** WE PROCESS K = ", k;
		    g := Random(S);
		    h := Function(factor2slp[i])(g);
		    assert NumberOfGenerators(Parent(h)) eq
			NumberOfGenerators(W);
		    assert g eq Evaluate(h, UserGenerators(H));
		end for;
		
		for k in [1 .. nMemberships] do
"****** PROCESS K = ", k;
		    g := Random(S);
		    h := getMapFunction(fromFactor[i] * toFactor[i])(g);
		    if Category(H) eq GrpMat then
			assert IsScalar(h * g^-1);
		    else
			assert h eq g;
		    end if;
		end for;
	    end for;
	catch err
	    ErrorOutput(err, "CompositionTreeSeries maps", G);
        end try;
    end if;
    
    try		
	for j in [1 .. nMemberships] do
	    g := Random(R);
	    o := Order(g);
	    k := CompositionTreeFactorNumber(G, g);
    
	    for j in [#toFactor .. Max(k - 1, 1) by -1] do
		if Category(Codomain(toFactor[j])) eq GrpMat then
		    assert IsDivisibleBy(o,
			CentralOrder(Function(toFactor[j])(g) :
			ParentGroup := Codomain(toFactor[j])));
		else
		    assert IsDivisibleBy(o, Order(Function(toFactor[j])(g)));
		end if;
	    end for;
	end for;
    catch err
	ErrorOutput(err, "CompositionTreeFactorNumber", G);
        return;
    end try;
end procedure;


/*
www-ATLAS of Group Representations.
2.M22.2 represented as 10 x 10 matrices over GF(9).
*/

F<w>:=GF(9);

x:=CambridgeMatrix(1,F,10,[
"0100000000",
"1000000000",
"0001000000",
"0010000000",
"0000001000",
"8484517000",
"0000100000",
"0000000100",
"3663306010",
"1200201001"]);

y:=CambridgeMatrix(1,F,10,[
"1000000000",
"0010000000",
"0000100000",
"0000010000",
"1220200000",
"0000000100",
"0000000010",
"2002020200",
"0000000001",
"2000002022"]);

G<x,y>:=MatrixGroup<10,F|x,y>;

TestGroup(G);


G :=
MatrixGroup<7, GF(5, 6) |
    [ W^14585, W^7839, W^10562, W^4523, W^1577, W^1442, W^10723, W^7877, 
W^142,
    W^7198, W^14671, W^10885, W^6550, W^12126, W^5610, W^13847, W^12643, 
W^9886,
    W^14786, W^8421, W^12656, W^11904, W^10384, W^7483, W^2012, W^3554, 
W^8671,
    W^14897, W^7571, W^13927, W^5013, W^4383, W^15109, W^14998, W^10546, 
W^9813,
    W^7303, W^10024, W^12979, W^8577, W^10765, W^15039, W^6847, W^4869, 
W^4167,
    W^6649, W^3710, W^14637, W^8800 ] where W := GF(5, 6).1,
    [ W^1270, W^4136, W^11033, W^598, W^7123, W^6844, W^4290, W^7371, 
W^5272,
    W^6434, W^3090, W^10780, W^11211, W^12480, W^6831, W^6862, W^10056, 
W^3114,
    W^4356, W^13186, W^12619, W^14151, W^12139, W^11285, W^12600, W^10874,
    W^8510, W^5254, W^800, W^9784, W^10370, W^9988, W^9914, W^3095, W^5060,
    W^9111, W^5775, W^11553, W^1578, W^1107, W^14864, W^12755, W^11615, 
W^3891,
    W^1561, W^15346, W^14240, W^9680, W^7955 ] where W := GF(5, 6).1,
    [ W^2232, 0, 0, 0, 0, 0, 0, 0, W^2232, 0, 0, 0, 0, 0, 0, 0, W^2232, 
0, 0, 0,
    0, 0, 0, 0, W^2232, 0, 0, 0, 0, 0, 0, 0, W^2232, 0, 0, 0, 0, 0, 0, 0,
    W^2232, 0, 0, 0, 0, 0, 0, 0, W^2232 ] where W := GF(5, 6).1 >
;
// T:=CompositionTree (G:KernelBatchSize:=100);
TestGroup (G);


G := CGU(3, 5^2);
M := GModule(G);
F := FrobeniusImage(M, G, 1);
T := TensorProduct(M, F);
G := ActionGroup(T);


TestGroup (G);

G := GL(8, 2^4);
TestGroup (G);

G :=
MatrixGroup<8, GF(5) |
   \[ 0, 4, 4, 3, 3, 3, 4, 1, 0, 0, 3, 4, 0, 3, 1, 2, 1, 1, 2, 2, 2, 2, 2, 3,
   0, 0, 4, 3, 2, 3, 2, 2, 4, 1, 1, 1, 0, 4, 2, 3, 1, 1, 0, 0, 0, 1, 4, 0, 4,
   4, 1, 1, 3, 3, 0, 2, 0, 4, 1, 2, 4, 2, 4, 3 ],
   \[ 0, 0, 0, 1, 1, 1, 4, 0, 2, 1, 4, 4, 2, 1, 4, 0, 4, 3, 0, 1, 3, 3, 3, 1,
   4, 1, 2, 1, 2, 1, 2, 2, 1, 0, 1, 2, 3, 0, 1, 1, 4, 2, 0, 2, 0, 0, 3, 2, 1,
   3, 1, 4, 2, 2, 1, 0, 0, 3, 0, 4, 2, 3, 4, 3 ],
   \[ 0, 0, 3, 1, 2, 1, 3, 2, 4, 1, 4, 4, 2, 2, 0, 2, 0, 2, 4, 1, 1, 2, 2, 4,
   3, 3, 3, 0, 3, 0, 3, 3, 1, 2, 2, 2, 0, 3, 1, 3, 2, 0, 4, 0, 1, 4, 0, 3, 1,
   3, 2, 2, 2, 0, 2, 4, 3, 1, 2, 0, 2, 0, 3, 1 ],
   \[ 0, 0, 0, 3, 0, 2, 0, 4, 0, 2, 0, 2, 0, 2, 1, 0, 0, 0, 4, 3, 1, 2, 3, 3,
   2, 0, 4, 0, 2, 2, 2, 1, 2, 4, 0, 1, 1, 4, 1, 1, 3, 4, 4, 4, 0, 1, 1, 4, 4,
   4, 1, 0, 1, 2, 0, 3, 0, 0, 2, 2, 0, 4, 2, 1 ],
   \[ 2, 1, 1, 0, 4, 3, 0, 0, 1, 2, 1, 3, 1, 3, 4, 4, 2, 0, 4, 0, 2, 3, 1, 4,
   0, 1, 2, 3, 3, 1, 3, 2, 0, 1, 4, 1, 0, 2, 2, 1, 1, 1, 3, 0, 3, 1, 2, 3, 2,
   2, 1, 0, 2, 3, 4, 3, 0, 0, 2, 3, 3, 2, 3, 2 ],
   \[ 4, 3, 0, 0, 0, 2, 3, 1, 4, 0, 4, 4, 1, 1, 0, 3, 0, 1, 1, 4, 4, 4, 4, 2,
   4, 3, 0, 0, 3, 3, 0, 2, 4, 1, 4, 3, 1, 4, 2, 1, 1, 1, 3, 3, 3, 2, 2, 1, 2,
   1, 2, 3, 2, 0, 0, 1, 4, 3, 0, 2, 4, 0, 2, 2 ],
   \[ 1, 3, 1, 2, 1, 1, 2, 0, 2, 3, 1, 1, 2, 2, 2, 1, 0, 0, 3, 4, 0, 4, 2, 2,
   2, 0, 1, 0, 1, 3, 4, 4, 0, 3, 3, 3, 3, 2, 0, 4, 1, 1, 1, 0, 1, 0, 1, 3, 0,
   1, 4, 0, 0, 1, 0, 0, 3, 1, 2, 4, 2, 1, 3, 0 ],
   \[ 4, 4, 1, 1, 3, 1, 3, 2, 1, 0, 2, 4, 2, 1, 1, 1, 1, 4, 3, 0, 3, 2, 1, 2,
   3, 4, 1, 0, 3, 3, 2, 0, 2, 1, 2, 3, 1, 4, 3, 4, 4, 4, 2, 4, 1, 1, 1, 2, 1,
   0, 3, 1, 0, 3, 4, 1, 3, 1, 2, 2, 0, 3, 1, 4 ],
   \[ 4, 4, 2, 0, 0, 1, 3, 4, 4, 2, 3, 1, 1, 0, 1, 4, 2, 1, 2, 0, 4, 0, 4, 3,
   3, 2, 3, 1, 1, 3, 0, 0, 2, 0, 4, 2, 1, 4, 1, 0, 1, 0, 3, 1, 4, 0, 3, 0, 0,
   2, 2, 1, 2, 2, 4, 2, 0, 3, 3, 0, 3, 4, 1, 4 ],
   \[ 1, 2, 4, 0, 1, 1, 0, 3, 4, 4, 4, 2, 1, 3, 3, 0, 4, 0, 2, 3, 3, 2, 4, 1,
   3, 4, 3, 3, 4, 0, 1, 3, 2, 4, 4, 0, 2, 0, 0, 0, 3, 2, 2, 4, 4, 3, 4, 0, 4,
   0, 0, 4, 0, 1, 3, 1, 3, 0, 0, 1, 2, 0, 3, 0 ],
   \[ 2, 0, 1, 3, 0, 2, 4, 3, 0, 4, 3, 3, 1, 3, 1, 3, 1, 0, 4, 3, 4, 4, 1, 0,
   2, 0, 2, 1, 3, 0, 1, 3, 3, 0, 2, 4, 1, 1, 2, 2, 2, 2, 3, 1, 3, 2, 2, 2, 1,
   0, 1, 1, 2, 0, 3, 2, 4, 1, 2, 0, 4, 0, 3, 2 ],
   \[ 3, 2, 1, 1, 3, 1, 4, 1, 0, 1, 4, 2, 0, 1, 0, 1, 0, 4, 4, 3, 4, 4, 0, 2,
   2, 1, 3, 1, 1, 0, 3, 0, 3, 0, 1, 3, 1, 2, 4, 4, 3, 4, 1, 2, 1, 1, 3, 1, 3,
   2, 1, 3, 2, 4, 0, 0, 3, 3, 3, 0, 4, 3, 1, 0 ],
   \[ 3, 0, 4, 0, 1, 4, 3, 0, 2, 4, 1, 2, 1, 3, 2, 2, 0, 3, 3, 3, 0, 2, 3, 2,
   3, 3, 4, 0, 3, 1, 2, 2, 3, 1, 3, 0, 3, 3, 4, 1, 2, 0, 2, 1, 0, 3, 0, 4, 1,
   3, 3, 2, 3, 3, 3, 2, 2, 0, 4, 3, 4, 1, 4, 2 ],
   \[ 4, 3, 1, 0, 0, 3, 0, 0, 2, 3, 2, 4, 0, 4, 0, 3, 0, 0, 1, 1, 0, 0, 0, 2,
   0, 0, 0, 1, 0, 0, 0, 0, 2, 3, 2, 0, 1, 3, 0, 2, 4, 3, 1, 0, 0, 4, 4, 3, 1,
   1, 3, 0, 0, 2, 4, 0, 3, 0, 2, 0, 0, 1, 3, 3 ],
   \[ 0, 4, 2, 4, 4, 2, 3, 1, 3, 4, 4, 1, 4, 4, 2, 4, 0, 3, 3, 4, 1, 3, 4, 0,
   0, 1, 2, 0, 2, 1, 3, 4, 3, 2, 4, 2, 0, 3, 1, 3, 1, 2, 2, 2, 2, 3, 0, 0, 0,
   2, 3, 3, 4, 2, 1, 1, 0, 1, 2, 1, 4, 2, 3, 0 ],
   \[ 0, 2, 3, 2, 3, 3, 2, 0, 0, 3, 4, 1, 2, 3, 4, 2, 2, 4, 1, 1, 2, 4, 4, 4,
   4, 2, 1, 1, 2, 0, 3, 3, 4, 4, 3, 0, 1, 1, 1, 4, 2, 1, 4, 1, 3, 0, 3, 3, 3,
   1, 1, 4, 3, 0, 3, 4, 4, 1, 1, 1, 1, 4, 0, 3 ],
   \[ 2, 0, 4, 2, 2, 2, 1, 1, 0, 0, 3, 3, 4, 1, 2, 0, 1, 2, 0, 0, 2, 1, 3, 0,
   0, 4, 3, 4, 2, 2, 0, 3, 4, 1, 0, 2, 3, 2, 1, 0, 1, 1, 0, 3, 4, 4, 4, 2, 3,
   1, 3, 0, 1, 1, 2, 2, 0, 1, 3, 1, 4, 4, 0, 3 ],
   \[ 0, 3, 3, 2, 2, 4, 3, 2, 0, 3, 3, 3, 0, 3, 1, 1, 0, 1, 0, 1, 1, 4, 2, 2,
   2, 1, 3, 1, 1, 0, 3, 0, 3, 2, 3, 3, 4, 3, 1, 3, 4, 1, 3, 1, 4, 4, 0, 4, 1,
   4, 1, 4, 3, 0, 0, 4, 3, 0, 3, 3, 2, 3, 4, 4 ],
   \[ 0, 1, 3, 1, 0, 2, 0, 0, 0, 4, 4, 2, 1, 1, 4, 4, 3, 1, 2, 1, 1, 0, 3, 3,
   1, 1, 3, 0, 1, 2, 4, 4, 2, 3, 4, 1, 3, 2, 4, 0, 0, 0, 4, 1, 0, 4, 1, 1, 1,
   3, 0, 0, 0, 1, 2, 1, 2, 0, 3, 4, 3, 4, 2, 4 ],
   \[ 0, 2, 2, 3, 3, 4, 0, 3, 3, 4, 4, 4, 4, 0, 0, 4, 0, 0, 3, 1, 1, 4, 2, 2,
   3, 2, 4, 0, 3, 1, 2, 1, 1, 3, 3, 1, 2, 3, 3, 2, 3, 1, 1, 0, 1, 4, 1, 1, 1,
   0, 2, 2, 2, 0, 3, 1, 4, 0, 3, 3, 4, 3, 3, 1 ],
   \[ 3, 3, 1, 4, 1, 1, 1, 2, 2, 4, 4, 2, 3, 2, 4, 1, 3, 4, 3, 0, 4, 0, 2, 2,
   2, 2, 3, 3, 1, 2, 3, 4, 3, 3, 4, 1, 1, 2, 2, 4, 2, 0, 3, 0, 0, 4, 0, 1, 4,
   1, 4, 0, 1, 2, 2, 2, 3, 2, 3, 4, 4, 4, 3, 4 ],
   \[ 1, 1, 2, 3, 3, 3, 4, 4, 4, 2, 1, 0, 1, 2, 4, 1, 4, 4, 1, 3, 0, 3, 0, 3,
   1, 3, 1, 1, 4, 3, 4, 0, 0, 0, 3, 0, 2, 2, 1, 3, 0, 2, 1, 1, 2, 2, 1, 3, 3,
   4, 2, 4, 1, 0, 2, 1, 1, 3, 0, 3, 2, 4, 3, 4 ],
   \[ 2, 1, 4, 0, 2, 4, 2, 2, 2, 3, 0, 4, 4, 3, 1, 0, 0, 2, 1, 1, 2, 0, 3, 1,
   2, 1, 4, 4, 2, 3, 4, 2, 0, 2, 3, 0, 3, 3, 0, 2, 0, 3, 0, 0, 4, 2, 2, 3, 0,
   2, 0, 2, 1, 1, 4, 0, 3, 0, 3, 3, 4, 2, 4, 4 ],
   \[ 2, 1, 3, 2, 0, 4, 2, 0, 2, 1, 2, 1, 3, 1, 3, 4, 3, 1, 4, 4, 2, 0, 2, 1,
   2, 1, 3, 3, 1, 0, 4, 4, 2, 3, 0, 1, 1, 0, 0, 2, 2, 2, 2, 4, 3, 1, 1, 1, 0,
   4, 0, 3, 1, 0, 3, 4, 2, 3, 2, 4, 4, 0, 1, 3 ],
   \[ 1, 2, 1, 0, 2, 2, 2, 0, 0, 2, 4, 0, 4, 1, 2, 2, 3, 4, 4, 2, 1, 4, 0, 1,
   0, 2, 0, 0, 1, 1, 0, 3, 3, 4, 3, 3, 1, 2, 3, 2, 0, 4, 2, 0, 4, 2, 1, 3, 2,
   2, 2, 1, 3, 4, 2, 2, 2, 2, 4, 0, 3, 3, 0, 0 ],
   \[ 4, 2, 4, 1, 4, 2, 1, 1, 2, 3, 0, 1, 1, 0, 3, 3, 4, 2, 4, 1, 1, 0, 1, 0,
   0, 2, 3, 3, 3, 2, 2, 0, 1, 1, 0, 3, 4, 0, 0, 0, 0, 1, 0, 2, 0, 0, 4, 4, 2,
   2, 4, 0, 4, 3, 3, 0, 2, 1, 2, 1, 0, 0, 2, 2 ],
   \[ 2, 4, 3, 2, 1, 1, 3, 2, 3, 0, 4, 1, 0, 3, 2, 2, 1, 1, 0, 0, 0, 4, 4, 1,
   4, 2, 3, 1, 2, 1, 4, 0, 4, 3, 1, 1, 3, 1, 0, 0, 2, 2, 3, 2, 2, 1, 1, 2, 1,
   2, 1, 2, 0, 1, 1, 2, 0, 0, 3, 4, 2, 1, 1, 1 ]
       /* order = 5859000 = 23 * 33 * 53 * 7 * 31 */ >;

TestGroup (G);

G:=MatrixGroup<9, GF(7) |
    \[ 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 2 ],
    \[ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1 ],
    \[ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1 ],
    \[ 6, 0, 0, 0, 0, 0, 1, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1, 0, 0, 0, 6, 0, 0, 0, 
    0, 0, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 6, 0, 0, 0 ],
    \[ 6, 0, 1, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 6, 0, 1, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 1, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 6, 0 ],
    \[ 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1 ],
    \[ 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1 ]
        /* order = 2^10 * 3^7 * 7^6 * 19^2 */ >;

TestGroup (G);


ConstructDual := function (G)
   M := GModule (G);
   U := Dual (M);
   T := TensorProduct (U, M);
   A := ActionGroup (T);
   return A;
end function;

MyAdjointRepresentation := function (d, q: Full := false)
   G := Full select GL(d, q) else SL(d, q);
   G := ConstructDual (G);
   M := GModule (G);
   CF := CompositionFactors (M);
   flag := exists(k){ k: k in [1..#CF] | Dimension (CF[k]) 
                  in {d^2 - 1, d^2 - 2}};
   assert flag;
   return ActionGroup (CF[k]);
end function;

G := MyAdjointRepresentation(4, 9);

TestGroup (G);


/*
www-ATLAS of Group Representations.
S4(5) represented as 12 x 12 matrices over GF(4).
*/

F<w>:=GF(4);

x:=CambridgeMatrix(1,F,12,[
"322300000000",
"103210030000",
"001311320010",
"223003230030",
"022113021112",
"002100332221",
"101001310013",
"033032232213",
"011310013211",
"300131130131",
"220310030010",
"312310230000"]);

y:=CambridgeMatrix(1,F,12,[
"221103113102",
"331211201330",
"013130303322",
"120303112211",
"202020033120",
"332012123020",
"232022313031",
"023031032102",
"213231100212",
"212001333310",
"320320203000",
"103213310203"]);

G<x,y>:=MatrixGroup<12,F|x,y>;

TestGroup (G);

G := MatrixGroup<8, GF(2, 4) |
    [ 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    W^5, 0, W^5, 0, 0, 0, 0, 0, W^10, 0, 0, W^10, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
    1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 ] where W := GF(2, 4).1,
    [ W, 0, 0, 0, 0, W^8, 0, 0, 0, W^14, 0, W^6, W^6, 0, W^13, 0, 0, 0, W^13, 0,
    0, 0, 0, W^5, 0, 0, 0, 1, 0, 0, W^7, 0, 0, 0, 0, 0, 1, 0, W^7, 0, 0, 0, 0, 
    0, 0, W^2, 0, 0, 0, 0, 0, 0, 0, 0, W, 0, 0, 0, 0, 0, 0, 0, 0, W^14 ] where W
    := GF(2, 4).1,
    [ 0, W^6, 0, W^9, W^9, 0, W^12, 0, W^9, 0, 0, 0, 0, W^12, 0, 0, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, W^2, 0, W^5, 0, 0, 0, 0, 0, W^7, 0, 0, W^10, 0, 0, 0, 0, 0, 
    W^12, 0, 0, 0, 0, 1, 0, 0, W^3, 0, 0, 0, 0, 0, 0, W^3, 0, 0, 0, 0, 0, 0 ] 
    where W := GF(2, 4).1,
    [ 0, 0, 0, 0, 0, 0, W, 0, 0, 0, 0, 0, 0, W^2, 0, 0, W, 0, 0, 0, 0, W^12, 0, 
    0, 0, 0, 0, W^5, 0, 0, W, 0, 0, 0, 0, 0, W^10, 0, W^6, 0, 0, 0, 0, 0, 0, 0, 
    0, W^14, 0, 0, W^13, 0, 0, 0, 0, W^9, 0, W^14, 0, W^10, W^10, 0, W^6, 0 ] 
    where W := GF(2, 4).1,
    [ 0, 0, 0, 0, 0, 0, W^2, W^8, 0, 0, W^13, W^12, W^2, W, W^3, W^9, W^14, W^5,
    0, W, W, W^10, W^12, 0, 0, 0, W^6, W^5, 0, 0, W, W^2, 0, 0, W^6, 0, W^10, 0,
    W^6, W^2, 0, 0, 0, 0, 0, 0, 0, W, 0, 0, W^14, 0, 0, 0, 0, W^10, 0, W^13, 0, 
    W^9, W^9, 0, W^5, 0 ] where W := GF(2, 4).1,
    [ 0, W^12, 0, 1, 1, 0, W^3, 0, W^12, 0, 0, 0, 0, 1, 0, 0, W^12, 0, 0, 0, 0, 
    0, 0, 0, 0, W^2, 0, W^5, 0, 0, 0, 0, 0, W^7, 0, 0, W^10, 0, 0, 0, 0, 0, 1, 
    0, 0, 0, 0, W^3, 0, 0, 1, 0, 0, 0, 0, 0, 0, W^12, 0, 0, 0, 0, 0, 0 ] where W
    := GF(2, 4).1,
    [ 0, W^14, W, W^13, W^13, 0, W^12, 1, W^10, W^11, W^13, W^6, W^4, W^9, W^2, 
    W^5, W^5, W^6, W^3, W^5, W, W^13, W^6, W^10, W^9, W^11, W^4, W^7, W^4, W^8, 
    W^11, 1, W^9, W^2, W^12, W^14, 0, W^8, W^6, W^10, 0, W^13, W, W^12, W^12, 0,
    W^11, 1, W^8, W^12, 1, W, W^6, W^7, 0, 0, W^4, W^8, W^5, W^6, W^11, W^12, 0,
    0 ] where W := GF(2, 4).1,
    [ W^8, W^9, W^5, W^7, W^3, 1, W^7, W^11, W^10, W^4, 1, W^6, 0, W^2, W^8, 
    W^12, W^8, W^2, W^14, W^11, W^3, W^3, W^9, W^11, W^7, W^7, W^6, W^3, W^2, W,
    W^14, W^8, W^10, 0, W^12, W^10, W, 0, W^6, W, W^6, W^7, W^10, W^2, W^11, 
    W^9, W, W, W^12, W^10, W^13, W^9, W^7, 1, W^9, W^9, W^12, W^10, W^7, W^8, 
    W^12, W^7, W, W^3 ] where W := GF(2, 4).1,
    [ 0, 0, W^7, W^13, W^3, W^9, W^4, W^3, 0, 0, W^4, W^10, 1, W^6, W^11, W^10, 
    W^12, W^11, 1, W^3, W^9, W^6, W^11, W^6, W^10, W^9, W^3, W^7, W^12, W^5, 
    W^11, 0, W^5, W^4, 0, 1, W^10, W^6, W^13, W^14, W^3, W^2, W, W^5, W, 1, 
    W^10, W^12, W^2, W^3, W^2, W^12, W^13, W^14, W, W^3, W^14, 1, W^4, W^10, 
    W^12, W^8, W^10, W^5 ] where W := GF(2, 4).1,
    [ W^10, W^11, 0, W^6, W^6, W^5, W, 0, 0, W^14, 0, W^9, W^9, 0, W^4, 0, 0, 
    W^14, W^4, W^9, W^9, 0, W^4, W^14, 1, W, W^11, W^12, W^11, W^10, W^7, W^6, 
    W^5, W^6, W^6, W, W^4, 1, W^14, W, 0, 0, W^13, W^2, W^7, W^11, W^7, W^8, 0, 
    0, W^13, W^2, W^7, W^11, W^14, 1, W^10, W^11, W, W^7, W^9, W^5, W^8, W^3 ] 
    where W := GF(2, 4).1,
    [ W, W^4, W^11, W^13, W^3, W^5, 0, 0, W^12, W^10, W^2, 0, W^4, W, W^13, W, 
    W^11, W^9, W^7, W^6, W^5, W^14, W^11, W^6, W^9, W^5, W^10, W, W^10, W^14, 
    W^3, W^6, W^7, W^11, W^8, W^13, W^2, 1, W^3, W^6, W^10, W^13, W, W^3, W^8, 
    W^10, 0, 0, W^7, W, W^4, W^2, W^4, W^7, W^8, W^11, W^12, W^6, W^4, W^6, W^7,
    1, W, W^11 ] where W := GF(2, 4).1,
    [ W^7, W^10, 1, W^3, W^10, W, 1, W^11, W^5, 0, 0, W^5, 1, W^14, W^4, 1, W^4,
    0, 0, W^4, W^14, W^9, W^14, W^14, W^8, W^14, W^4, 0, W^7, W^12, W^14, W^4, 
    W^14, W^4, W^9, W^4, W^10, 1, W^11, W^2, W^9, W^12, W, W^13, 0, 1, W^14, 
    W^12, W^12, W^11, 1, W^9, W^3, W^3, W^11, W^9, W^9, W^8, W^13, W^10, W^11, 
    W^14, W^7, W^7 ] where W := GF(2, 4).1,
    [ W^8, W^12, W^14, 1, W^5, W^6, 0, 0, W^2, W^12, W^14, W^11, W^13, 1, 1, 
    W^4, W^5, 1, W^7, W, W^13, W^4, W^4, W^12, W^3, W^8, W^6, W^3, 0, W^10, W^5,
    W^9, W^5, W^2, W^10, W^9, W^7, 0, W^5, W^9, 1, W^4, W^4, W^5, W^10, W^11, 0,
    0, W^9, W^8, W^8, 0, W^9, W^5, W^10, W^14, W^5, W^4, W^11, W^4, W^6, W^4, 
    W^9, W^2 ] where W := GF(2, 4).1,
    [ 0, 0, W^5, W^3, W^8, W^6, W^4, W^11, 0, 0, W^12, W^10, 1, W^13, 1, W^7, 
    W^8, 1, W^8, W^7, W^14, W, W^3, W^3, W^11, W^3, W^4, W^14, 1, W^12, W^2, 
    W^2, W^6, W^13, 1, W^11, W^13, W^8, W^12, W^12, W^9, W, W^5, W^4, W^11, 
    W^13, W^11, W^11, W^9, W^9, W^13, W^3, W^8, W^13, 0, 0, W, W, W^9, W^14, 
    W^4, W^9, 0, 0 ] where W := GF(2, 4).1,
    [ W^10, W^6, W^9, W^12, W, W^13, W^13, W^13, W^12, W^4, W^7, W^6, W^13, 1, 
    W^12, W^12, W^9, W, W^5, W^2, W^14, W^8, W^5, W^10, W^13, 0, W^5, W^10, 
    W^14, W^5, W^12, 1, W^5, W^3, W^13, W^14, W^3, W^9, W^4, W^12, W^14, W^10, 
    W, W^11, W^3, W, W, W^5, W^3, W^2, W^8, 0, W^9, W^5, W, W^5, W^11, W^10, 
    W^14, W^13, W^6, W^10, W^6, W^11 ] where W := GF(2, 4).1,
    [ W^14, W^11, W^11, W^4, W^9, W^2, 0, 0, W^6, W^8, W^8, W^6, 0, W^9, W^4, W,
    W^8, W^10, W^2, W^11, W^12, W^12, W^7, W^10, W^10, W, W^5, W, W^8, W^8, 
    W^11, W^8, W^8, W^12, 0, W^3, W^7, W^4, W^11, W^8, 1, W^12, W^3, W^11, W, 
    W^9, 0, 0, 1, W^11, W^2, W^2, W^3, W^9, W^3, 1, W, W^12, W^4, W^9, W^12, 
    W^5, W^14, W^2 ] where W := GF(2, 4).1,
    [ 1, W^6, W^12, W, W^11, 0, 0, W^12, W^3, 0, 0, W^4, W^14, 0, 0, 1, W^13, 0,
    0, W^14, W^9, W^12, W^3, W^10, 0, W^6, W^12, 0, W^5, W^4, W^10, W^6, W^10, 
    W^11, W^2, W^14, W^6, W^14, W^5, W^10, W^12, W^3, W, W^14, W^11, W^6, W^12, 
    W, W^2, W^13, W^11, W^6, W^13, W^11, W^3, W^7, 1, W^11, W^2, W^8, W^14, 
    W^14, W^6, W^13 ] where W := GF(2, 4).1,
    [ W^4, W^7, 1, W^5, W^14, W^10, W^7, W^9, W^2, W, W^9, W^13, W^9, W^8, W^12,
    W^14, W^9, W^8, W^6, W, W^14, W^6, W^10, W^11, W^10, W^3, 1, W^11, W^9, W^8,
    W^6, W^4, W^14, 1, W^11, W^8, W^9, 0, W^9, W^12, W^10, W^13, W^14, W^14, 
    W^10, W^5, W^2, W^8, W^13, W^7, W^8, W^11, W^10, W^8, W^8, W^14, W^14, W^8, 
    W^6, W^13, W, W^11, W^11, W^12 ] where W := GF(2, 4).1,
    [ W^4, W^14, W, W^2, W^3, W^10, 1, W^11, W^11, W^3, W^5, W^12, W, W^2, W, 
    W^12, W^14, W^6, W^2, W^6, W^7, W^2, W, W^9, W^9, W^9, W, W^12, W^14, W, 
    W^11, W^12, 1, W^11, W^12, W, W^13, W^8, W^12, W^9, W, W^11, W^5, W^13, W^9,
    W^12, W^2, 1, W^8, W^5, W^14, W^13, W^14, W^4, W, W^14, W^14, W^11, W^7, 
    W^12, W^3, W^2, W^14, W^7 ] where W := GF(2, 4).1,
    [ W^12, 1, W^12, W^7, 1, 1, W^4, W^13, W^10, 1, W^12, W^6, W^10, W^13, W^7, 
    W, W, W^6, W^10, 0, W^5, W^10, W^4, W^14, W, W^12, 1, W^11, W^5, W^9, W^9, 
    W, W^9, W^4, W^5, W^13, W^12, W^8, W^3, W^6, W^12, 1, 0, W, W, W^13, W^2, 0,
    W^12, W^13, 0, W^14, W^14, W^13, 1, 0, W^3, W^4, W^8, W^14, W, W^12, W^14, 
    W^9 ] where W := GF(2, 4).1,
    [ W, W^6, W^12, W^3, W^4, W, W^10, W, W^11, W^7, W^13, W^2, 0, W^11, W^12, 
    W^3, 0, 0, W^14, W^8, W^13, W^7, W^8, W^4, W^4, 1, W^14, W, W^7, W^3, W^8, 
    W^13, W^4, 1, W^2, W^3, W^8, W^10, W^14, W^14, W^9, W^14, W^14, 1, W^7, 
    W^11, W^5, W^3, W^12, W^8, W^8, W^6, W^4, W^14, W^5, W^3, 0, 0, W^7, W, W^6,
    1, W^6, W^2 ] where W := GF(2, 4).1,
    [ W^3, W^11, W^9, W^14, W^7, W^2, W^7, W^6, W^14, W^4, W^2, W^4, W^6, W^13, 
    W^9, W^8, W^11, W, W^13, W^5, W^4, W^6, W^2, W^4, W^7, W^8, W^12, W^3, W^5, 
    0, W^3, 1, W^9, 0, W^14, W^13, W^13, W^10, W^14, W^8, W^2, W^10, W^10, 0, 
    W^2, W^4, W^9, W^7, W^5, W^12, W^12, W^3, W^11, W^7, W^14, W^12, W^3, W^10, 
    W^7, 1, 0, W^13, W^5, W^7 ] where W := GF(2, 4).1,
    [ W^3, 0, 0, 0, 0, W^10, 0, 0, W^10, W^12, 0, W^4, W^4, W^2, W^11, 0, 1, 
    W^2, W^9, W^8, W^11, W^13, W^7, W, W^2, W, 0, W^2, W^8, W^12, W^9, 0, 1, W, 
    0, W^8, W^2, W^4, W^9, 0, W^7, 0, 0, 0, 0, W^8, 0, 0, W^10, W^5, 0, W^6, 
    W^6, W^11, W^7, 0, W^11, W^6, W^13, W^11, W^5, W^9, W^5, W^14 ] where W := 
    GF(2, 4).1,
    [ W^5, W^3, 1, 1, W^8, W^13, W^2, W^6, W^12, W^8, W^5, 1, W^7, W^5, W^11, 1,
    W^9, W^5, W^4, W^6, W^14, W^6, W^12, W^14, W^10, W, W^6, W^8, W^6, W^2, 
    W^10, W^6, W^4, W^4, W^8, W, W^3, W^13, W^12, W^9, W^14, W^12, W^7, 1, W^7, 
    W^3, W^7, W^13, W^12, W^2, W^12, W^3, W^4, W, W^14, W^5, 1, W^5, W^4, W^11, 
    W^10, W^12, W^10, W^12 ] where W := GF(2, 4).1,
    [ W^2, W, W^11, W^11, 1, W^9, W, W^4, W, W^4, W^14, W, W^6, W^8, 0, 0, W^10,
    W^13, W^4, W^6, W^11, W^13, 0, 0, W^12, W^4, W^5, W, W, W^2, W^11, W^14, 1, 
    W^2, W^2, W^5, W^4, W^13, W, W^4, W^14, W^13, W^6, W^4, W^3, W^11, W^3, 
    W^14, W, W^5, W^13, W^10, W^13, W^13, W^8, W^4, W^13, W^2, W^8, W^12, W^6, 
    W, W^11, W^14 ] where W := GF(2, 4).1,
    [ W^11, W^5, W^4, 1, W^5, W, 0, 0, W^10, 0, 0, W^4, W^14, 1, W^14, W^8, W^3,
    0, 0, W^12, W^7, W^4, W^3, W, W^5, W^3, W^2, W^6, W^14, W^8, 1, W^9, W^8, 
    W^8, W^7, W^11, W, W^4, 1, W^9, W^7, W, W^5, W, W^6, W^2, 0, 0, W^8, W^9, 
    W^13, W^3, W^10, W^3, W, W^10, W^5, W^6, W^5, W, 1, W^6, W^4, W^2 ] where W 
    := GF(2, 4).1,
    [ W^9, W^7, W^5, W^9, 1, W^13, W^12, W^6, W^4, W^8, W^6, 0, W^2, W^8, W^11, 
    W^5, W^2, W^6, W^3, W^8, W^6, W^8, W^11, W^2, W^7, W^7, W^2, W^9, W, W^10, 
    W^8, W^7, 0, W^13, 0, W^7, 1, W^9, W^9, W^4, W^7, W^5, W^11, W^2, W^14, W^2,
    W, W^12, W^10, W^7, W^13, W^9, W^3, W^5, 1, W^11, W^10, W^7, W^4, W^14, W, 
    W, W^11, W^2 ] where W := GF(2, 4).1,
    [ W^4, W^3, W^12, W, W^12, W^11, W, W^3, W^8, W, W^10, W^9, W^11, 1, W^7, 
    W^9, W^9, W^2, W^10, W^14, W^13, W^12, W^4, W^9, W^2, W^8, W^9, W^14, W^11, 
    W^14, W, W, W, W^5, W^8, 1, W^9, W^6, W^12, W^9, 1, W^14, W^13, W^8, W^6, 
    W^13, W^3, W^4, W^4, W^2, W, W^6, W^2, W^2, W^12, W^13, W^9, W^7, 1, W^3, 
    W^6, W^12, W^7, W^12 ] where W := GF(2, 4).1,
    [ W^8, 1, W^9, W^3, W^6, W^3, W^14, W^13, W^2, W^10, W^4, W^9, W^2, W^12, 
    W^13, W^12, W^10, W^3, W^5, W^9, W^8, W^7, W^8, W^13, W^10, W^6, W^3, W^2, 
    W^9, W^12, W^10, W^3, W^8, W^14, W^12, W^14, W^11, W, W^13, 1, W^13, W^5, 
    W^4, W^11, 1, W, W^12, W^8, W^4, W^7, W^6, W^9, W, W^7, 1, W^11, W^7, W^10, 
    W^12, W^3, W, W^4, W^12, W^2 ] where W := GF(2, 4).1,
    [ W^13, W^8, W^7, W^4, W^6, W^8, W^5, W^9, W^7, W^13, W^12, W^10, W^7, W^2, 
    W^9, W^13, W^4, W^10, W^4, W^5, W^7, W^13, W^5, W^5, W^14, W^13, W^6, W^14, 
    W^3, W, W^7, 1, W^11, W^7, W^8, W^12, W^6, 1, W^14, W^4, W^9, W^4, W^7, W^3,
    W^10, W^9, W^6, W^9, W^8, W^2, W^5, W^3, W^5, W^8, W^9, W^12, W^9, W^3, 
    W^12, W, W^9, W^3, W^4, W^4 ] where W := GF(2, 4).1,
    [ W^3, W^7, W^10, W^2, W^3, W, W^7, W^12, W^14, W, W^4, W^5, W, W^12, W^11, 
    W, 0, 0, W^5, W^8, W^13, W, 1, W^2, W^7, W^9, W^4, W^5, W^4, W^10, W, W^10, 
    W^7, W^9, W^13, W^11, 1, 1, W^6, W^9, W^11, 1, W^6, W^12, W^7, 0, 0, W^8, 1,
    W^2, W^8, W, W^11, 0, 0, W^12, 0, 0, W^13, W, W^6, W^9, 1, W^2 ] where W := 
    GF(2, 4).1,
    [ W^12, W^2, W, W^7, W^8, W^5, W^7, W^13, W^7, 0, 0, W, W^11, 1, W^14, W^5, 
    W^9, 0, 0, W^3, W^13, W, 1, W^7, W^7, W^9, W^8, W^5, W^6, W^10, 0, W^13, W, 
    W^14, W^13, W^7, W^13, W^7, W^8, W^6, W^8, W^13, W^3, W^12, W, W^4, W^6, 1, 
    W^11, 1, W^5, 0, W, W^7, W^2, W^11, W^2, W^6, W^5, W^4, 1, W^9, W^4, W^11 ] 
    where W := GF(2, 4).1,
    [ 1, W^9, W^7, W^12, W, 1, W^10, W^8, W^11, W^9, W^7, W^14, W^4, W^11, 0, 0,
    W^10, W^8, W^4, W^11, W, W^8, 0, 0, W^6, W^9, 0, W^7, W^4, W^13, W^12, W^10,
    W^8, W^12, W^4, W^10, W^14, W, W^2, 1, W, W^10, W^9, W^3, W^14, W^3, W^13, 
    W^10, W^6, W^2, W, W, W^2, W^8, W^10, W^7, W^4, 1, W^11, W^9, W^7, W^2, W^4,
    W^2 ] where W := GF(2, 4).1,
    [ W^9, W^2, W^12, W^13, W^11, W^9, W^10, W^5, W^7, 0, 0, W^12, W^7, W^7, 
    W^2, W^12, W^3, 0, 0, W^8, W^3, W^11, W^6, W^8, W^8, W^3, W^13, W^8, W^7, 1,
    W^14, W^10, W^4, W^8, W^3, W^3, W^5, W^6, 0, W^8, W^3, W^11, W^7, 0, W^14, 
    W, W^2, 1, W^11, W^7, W^3, W, W^14, W^9, W^11, W^9, W^13, W^9, W^4, W^6, 
    W^14, W^6, W^8, W^10 ] where W := GF(2, 4).1,
    [ W^8, W^13, W, W^4, W^13, W^7, W^14, W^3, W^8, 0, 0, W^6, W, W^7, W^10, 
    W^14, W^2, 0, 0, 1, W^10, W^8, W^11, W^8, W, W^12, 1, W^10, W, W^10, W^14, 
    W^9, W^5, W^2, W^5, W^13, W^12, W, W^3, W^8, W^14, W^4, W^13, 1, W^2, W^9, 
    W, 1, W^4, W^13, W^7, 0, W^13, W^14, W^13, W^12, W^7, W, W^4, W^13, W^9, 
    W^13, W^12, W^9 ] where W := GF(2, 4).1,
    [ W^10, W^7, W^6, 1, W^7, W^4, W^12, W^2, W^4, W^6, W^5, W^6, W^2, W^13, 
    W^8, W^13, W^12, W^14, 1, W^4, W^11, W^3, W^13, W^8, 0, 1, W^13, W^13, W^13,
    W^3, W^6, 1, W^3, 0, W^12, W^11, W^6, W, W^3, W^11, W^14, W^11, W, 1, W, 
    W^6, W^14, W^12, W^2, W^9, W^14, W^5, W^13, W^9, W^6, W^4, W^6, W^13, W^14, 
    W^10, W^6, W^12, W^9, W^4 ] where W := GF(2, 4).1,
    [ W^10, W^9, W^3, W^12, W^6, W^6, W^4, W^2, W^13, W^5, W^14, W^5, W^13, W^9,
    W^10, W^8, W^13, W^5, W^7, W^12, W^11, W^11, W^12, W, W^8, W^4, W^6, W, W, 
    W^14, W^5, W^10, W, W^14, W, W^2, W^9, W^6, W^9, 0, W^14, W^13, 1, W^4, 1, 
    W^14, W^12, W^14, W^8, 0, 0, W^5, 1, W^8, W^10, W^12, W^4, 0, 0, W, W^11, 
    W^2, W^4, W^8 ] where W := GF(2, 4).1,
    [ W^7, W^4, W^8, W^3, W^5, W^5, W^7, W^13, W^2, W^10, W^14, W^10, W^7, 1, 
    W^12, W^3, W^14, W^7, W^9, W, 0, W^13, W^10, W^13, W^6, 1, W^12, W, W^14, 1,
    W^11, 0, W^12, W^4, W^10, W^10, 1, W^14, W^3, W^8, W^10, W^7, W^3, 1, W^13, 
    W^7, W^9, W^8, W^11, 1, W^11, W^7, 0, W^8, W^14, W^13, W^5, W^9, W^11, 1, 
    W^9, W^4, W^10, W^13 ] where W := GF(2, 4).1,
    [ W^11, W^4, W^14, W^10, W^7, 1, W^3, W^9, W^9, W^4, W^14, W^6, W^12, W^13, 
    W^9, 1, W^6, W, W^9, W^10, W^11, W^3, W^14, W^10, W^9, W^9, W^6, W^11, W^3, 
    W^10, W^13, 0, W^12, W^3, W^5, W^7, W^11, 1, W^3, W^4, W^12, W^5, W^8, W^10,
    W^5, 0, 0, W^3, W^2, W^3, W^6, 1, W^10, 0, 0, W^8, W^13, W^14, W^7, W^6, 0, 
    W^10, W^13, W^9 ] where W := GF(2, 4).1,
    [ W, W^13, W^3, W^11, W, W^9, 0, 0, W^14, W^10, 1, 1, W, W^7, 1, W^12, W^7, 
    W^3, W^4, W^6, W^14, W^6, W^14, W, W^11, W, W^2, W^9, W, W^2, W^7, W^4, W^2,
    W^11, W^12, W^6, W, 1, W^7, W^4, W^12, W^9, W^10, W^3, W^8, W, 0, 0, W^9, 0,
    0, W^5, 1, W^13, W^14, W^11, W^6, 0, 0, W^2, W^12, W^5, W^6, W^8 ] where W 
    := GF(2, 4).1,
    [ 0, 0, 0, 0, 0, W^5, W^10, 0, 0, 0, 0, 0, 0, W^14, W^3, 0, W, 0, 0, 1, 
    W^10, W^5, W^9, W^9, W^2, 0, 0, W^2, W^11, W^5, 0, W^11, W^12, 0, 0, W^11, 
    W^7, W^3, W, W^6, W^13, 0, 0, W^13, W^8, W^8, W^13, W^8, W^2, W^8, W^13, 
    W^6, W^10, W^12, W^14, W^9, W^11, W^2, W^6, W^7, W^9, 1, W^2, W^2 ] where W 
    := GF(2, 4).1,
    [ W^12, 0, 0, 0, 0, 0, 0, 0, 0, W^12, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 
    0, 0, 0, 0, 0, 0, W^3, 0, 0, 0, 0, 0, 0, 0, 0, W^3 ] where W := GF(2, 4).1,
    [ W^8, W^8, W^2, 0, W^2, W^12, W^11, W, W^7, 0, 0, W^11, W^6, W^11, W^5, 
    W^10, W^11, 0, 0, 1, W^10, W^3, W^12, W^14, 0, W^2, W^11, W^6, W^9, W^10, 
    W^11, W^7, W^12, W^7, W, W^7, 0, W^2, W^5, W^13, W^3, W^3, W^13, W^6, 1, 
    W^14, W^13, W^12, W^2, W^7, W^2, W^4, W^6, W^13, W^6, W^5, W^11, W, W^10, 
    W^2, W, W^3, W^11, W^13 ] where W := GF(2, 4).1,
    [ W^14, W^2, W^6, W^11, W^5, W, W^9, W^11, W^11, W^7, W^11, W^13, W^6, W^13,
    W^9, W^11, W^14, W^10, 0, W^10, W^10, W^14, W^10, 0, W^8, W^6, W^2, W, W^14,
    1, W^10, W^2, 1, W^9, W^2, W, W^3, W^8, 0, W^2, W^14, W^2, W^12, W, W^3, 
    W^12, W^5, W^2, W^9, W^13, W^8, W^10, W^2, W^7, W^11, W^8, W^12, W, 0, W, W,
    W^12, W, 0 ] where W := GF(2, 4).1,
    [ W^9, W^10, W^10, W^4, W^14, 0, 0, W^9, W^9, W^7, W^7, W^4, W^14, 0, 0, 
    W^9, W, W^14, 0, W, W, W^3, W^3, 0, 1, W^8, W^9, W^8, W^6, W^13, W^13, W^11,
    W^4, 1, W^9, 0, W^3, W^8, W^8, W^11, W^13, W^14, W^12, W^12, 1, W^3, W^3, 
    W^11, W, W^13, W^11, W, W^7, W^6, W^5, W^13, W^4, W, 0, W^3, W^3, W^6, W^5, 
    0 ] where W := GF(2, 4).1,
    [ W^13, W^9, W^5, W^13, W^10, 1, W^4, W^13, W^14, W^14, W^10, W^2, W^4, W, 
    W^10, W^4, W^4, W^4, W, 1, W^4, W^12, W^6, W^10, W^6, W^9, W^6, W^14, W^5, 
    W^3, W^11, W^6, W^2, W^4, W, W^4, W^6, W^5, W^12, W^12, W^13, W^9, W^6, W^8,
    W, W^8, W^12, W^14, 1, 0, 0, W^7, W^2, W^10, W^7, W^9, W^5, 0, 0, W^12, W^7,
    W^13, W^10, W^14 ] where W := GF(2, 4).1,
    [ W^6, W^12, 1, W^14, W^4, W^3, 0, 0, W^10, W^3, W^6, W^2, W^14, W^7, W^3, 
    W^9, 1, W^8, W, W^4, W^5, W^14, W^10, W^4, W^10, W^14, W^4, 1, W^14, W^8, 
    W^13, W^4, W^14, W^13, W^2, W^6, W^5, W, W^13, W^4, W^4, W^10, W^10, W^9, 
    W^14, W^13, 0, 0, W^5, W^3, W^3, W^11, W^3, W^14, W^8, W^14, W^12, W^10, 
    W^3, W^7, W^13, W^11, W^5, W^14 ] where W := GF(2, 4).1,
    [ 0, 0, W^11, W^13, W^3, W^5, W^10, W^13, 0, 0, W^4, W^6, W^11, W^13, W^4, 
    W^7, W^14, W^2, W^3, 0, 1, W^7, W^13, W^6, W, W^4, W^13, W^9, W^9, W^10, 
    W^12, W^11, W^11, W^14, W^9, W^6, W^5, W^11, W^6, 1, W^13, W, W^13, W^14, 
    W^11, W^9, W^14, 1, W^6, W^12, W^9, W^3, 0, W^2, W^9, W^10, W^14, W^5, W^6, 
    W^9, W^7, W^7, W^14, W^7 ] where W := GF(2, 4).1,
    [ 1, W^8, W^8, W, W^4, 1, W^2, W^2, W^3, W, W, W^12, W^10, W^3, W^9, W^9, 
    W^9, W^7, W^8, 0, W^10, W^7, W^13, W, W^9, W, W^12, W^5, W^6, 1, W^4, W, 
    W^5, W^7, W^11, W^7, W^7, W, W^12, W^3, W^14, W^7, W^6, W^9, W^10, W^4, W^6,
    1, W^2, W^2, W, W^8, W^10, W^7, W^4, W^13, W^9, W^9, W^10, W^13, W^9, W^7, 
    W^4, W^7 ] where W := GF(2, 4).1,
    [ W^8, 1, W^5, W^2, W^14, W^8, W^6, W^11, W^4, W^8, W^13, W^5, W^6, W^4, 
    W^12, W^2, W^11, 1, W^2, W^7, W^5, W^7, 1, W^6, W, W^4, W, W^4, W^10, W^14, 
    W^3, W^3, W^4, W^3, W^3, W, W^4, W^10, W, W^14, W^6, W^13, W^14, W^6, W^10, 
    W^11, W^9, W^5, W^6, W^8, W^9, W^14, W, W^11, W^10, W^6, 1, W^2, W^4, W, 
    W^5, W^11, W^10, W ] where W := GF(2, 4).1,
    [ W^13, W^12, 1, W^2, W^5, W^10, 1, W^6, W^6, 0, 0, W^4, W^14, W^3, W^6, 
    W^12, 1, 0, 0, W^13, W^8, W^8, W^11, W^6, W, W^11, W^14, W^6, W^14, W^4, 
    W^14, W^13, W^14, W, W^4, W^8, W^5, W, W^12, W^6, W^5, W^4, W^10, W^8, W^7, 
    1, W^5, W, W^12, W^13, W^4, W^3, 0, W^7, W^8, W^4, W^14, 1, W^3, W^9, W^11, 
    W^7, W^8, W^3 ] where W := GF(2, 4).1,
    [ W^5, W^6, W^4, 0, W^3, W^12, 1, W^6, W^12, W^9, W^7, W^2, W^4, W^4, 1, 
    W^6, W^14, W^11, W, W^13, W^11, W^5, W, 1, W^4, W^8, W^7, W^10, W^12, 1, 
    W^7, W^11, W^3, 0, W^5, W^4, W^8, W^6, W^14, W^12, W^14, 1, W, W, W^4, W^7, 
    W^10, W^3, W^4, W^7, W^8, 0, W^5, W^12, W^3, W^11, W^12, 1, W^5, W^4, W^10, 
    W^3, W^9, W^8 ] where W := GF(2, 4).1,
    [ W^3, W^8, W, W^3, W^5, W^12, W^3, W^2, W^5, W^3, W^11, W^9, W^10, W^14, 
    W^10, W^9, 0, 0, W^6, W^13, W^3, W^10, W^6, W^4, W^12, W^10, W^2, W^11, W^6,
    W^2, W^2, W^6, W^12, W^10, W^9, W^10, W^3, 1, W^13, W^4, W^10, 1, W^10, W^8,
    W^4, W^12, W^3, W^11, W^4, W^2, W^12, W^14, 0, W^6, W^11, W^4, 0, 0, W^13, 
    W^5, W^10, W^2, W^7, W^5 ] where W := GF(2, 4).1,
    [ W^2, W, 0, W^5, W^5, W^6, W^9, 0, W^8, W^14, 0, W^3, W^3, W^12, W^7, 0, 
    W^5, W^11, W^10, W^7, W^3, W^10, W^5, W^14, 0, W^12, W^7, W^12, W^6, W^2, 
    W^4, W^11, W^14, W, W^2, W^2, W^7, W^10, W^3, W^6, W^13, W^12, W^14, W^2, 
    W^8, W^5, W^8, W^3, W^5, W^5, W^7, W^7, 0, W^12, W^9, W^4, W^6, W^6, W^5, 
    W^12, W^14, W^11, W^8, W^2 ] where W := GF(2, 4).1 >
;
TestGroup (G);
