/********************************                                             
 * Tests Bug report 143                                                      
 ********************************/

// Timing Hecke eigenvalue of f (over the field F) for prime of norm p
function time_eigenvalue(F, f, p)
    pp := PrimeIdealsOverPrime(F, p)[1];
    inert := Conjugate(pp) eq pp;
    // printf "\nEigenvalue for prime of norm %o (%o)\n",
    //  Norm(pp), inert select "inert" else "split";
    t0 := Cputime();
    ev := HeckeEigenvalue(f, pp);
    t := Cputime() - t0;
    return Norm(pp), t, ev, inert;
end function;

procedure test_Bug_143(inert_split_ratio, max_test_time)
    F<sqrt5> := QuadraticField(5);
    ZF := Integers(F);
    N := (1+4*sqrt5)*ZF;
    S22 := NewformDecomposition(NewSubspace(HilbertCuspForms(F, N, [2,2])));
    f79 := Eigenform(S22[1]);

    timings := [];
    evs := [];
    for p in [311,17,1381,37,2221,47] do
        np, t, ev, inert := time_eigenvalue(F, f79, p);
        Append(~timings, <np, t, inert>);
        Append(~evs, ev);
    end for;
    
    assert evs eq [20, 2, -66, 34, 46, -74];
    vprintf ModFrmHil, 1 : "%o\n", timings;

    inert_time := &+[x[2] : x in timings | x[3]];
    split_time := &+[x[2] : x in timings | not x[3]];
    total_time := inert_time + split_time;
    
    vprintf ModFrmHil,1 : "inert_time = %o\n", inert_time;
    vprintf ModFrmHil,1 : "split_time = %o\n", split_time;

    assert inert_time lt inert_split_ratio*split_time;

    vprintf ModFrmHil,1 : "total_time = %o\n", total_time;
    assert total_time lt max_test_time;

    return;
end procedure;

// At the moment, 3 and 100 work
// But can try to improve them
// In original bug report, the ratio between inert and split was ~12 
// and the total time was 130 s
if assigned verbose then
    SetVerbose("ModFrmHil", eval verbose);
end if; 
test_Bug_143(3, 50);
exit;