SetSeed(23);

/********************************
 * Tests Example 4 from [LW12]
 ********************************/
procedure test_LW12_Ex4_Level27()
  // Create the corresponding space of modular symbols
  ms := ModularSymbols(27);
  Snew := NewSubspace(CuspidalSubspace(ms));
  nfd := NewformDecomposition(Snew);
  assert #nfd eq 1;
  Vf := nfd[1];
  pi := LocalComponent(Vf, 3);  
  assert IsMinimal(pi);
  assert IsSupercuspidal(pi);
  assert Conductor(pi) eq 27;
  assert IsTrivial(CentralCharacter(pi));
  rho := CuspidalInducingDatum(pi);
  assert Dimension(rho) eq 2;
  // det g does not lie in the index 2 subgroup generated by 3
  // if and only if it is 2 mod 3
  assert &and[Trace(Representation(rho)(c[3])) eq 0 :
	      c in ConjugacyClasses(Group(rho)) | Determinant(c[3]) in [2,5,8]];
  E, chi := AdmissiblePair(pi);
  E := FieldOfFractions(E);
  Q3 := BaseRing(E);
  assert Q3 eq pAdicField(3, Precision(Q3));
  _<x> := PolynomialRing(Q3);
  K := ext<Q3 | x^2 + 3>;
  assert IsIsomorphic(E,K);
  _, sqrt_m3 := IsSquare(E!(-3));
  zeta := chi(1+sqrt_m3);
  assert MinimalPolynomial(zeta) eq CyclotomicPolynomial(3);
  // Should also check that chi(sqrt(-3)) eq -1,
  // but at the moment the constructed chi cannot be applied
  // to non-units.
  return;
end procedure;

procedure test_LW12_Ex4_Level54()
  // Create the corresponding space of modular symbols
  ms := ModularSymbols(54);
  Snew := NewSubspace(CuspidalSubspace(ms));
  nfd := NewformDecomposition(Snew);
  assert #nfd eq 2;
  for Vf in nfd do
    pi := LocalComponent(Vf, 3);  
    assert IsMinimal(pi);
    assert IsSupercuspidal(pi);
    assert Conductor(pi) eq 27;
    assert IsTrivial(CentralCharacter(pi));
    rho := CuspidalInducingDatum(pi);
    assert Dimension(rho) eq 2;
    // det g does not lie in the index 2 subgroup generated by 3
    // if and only if it is 2 mod 3
    assert &and[Trace(Representation(rho)(c[3])) eq 0 :
	      c in ConjugacyClasses(Group(rho)) | Determinant(c[3]) in [2,5,8]];
    E, chi := AdmissiblePair(pi);
    E := FieldOfFractions(E);
    Q3 := BaseRing(E);
    assert Q3 eq pAdicField(3, Precision(Q3));
    _<x> := PolynomialRing(Q3);
    K := ext<Q3 | x^2 - 3>;
    assert IsIsomorphic(E,K);
  end for;
  return;
end procedure;

procedure test_LW12_Ex4()
  test_LW12_Ex4_Level27();
  test_LW12_Ex4_Level54();
end procedure;

test_LW12_Ex4();

exit;

// [LW12] D. Loeffler, J. Weinstein -
// On the computation of local components of a newform,
// Math. Comp. 81, 2012, 278, 1179--1200
