/********************************
 * Tests Example 2 from [LW12]
 ********************************/

// This procedure checks that the character theta inducing the
// local representation
// pi_f, where f has level N, weight k and q-expansion qexp,
// satisfies that thets(alpha) is a root of unity of order order
// It is used several times in the test, verifying Table 2 in [LW12]

procedure test_LW12_Ex2(N, k, qexp, order)
  // Create the corresponding space of modular symbols
  ms := ModularSymbols(Gamma1(N),k);
  Snew := NewSubspace(CuspidalSubspace(ms));
  nfd := NewformDecomposition(Snew);
  l := AbsolutePrecision(qexp);
  // Would want to just do this, but fields might be different
  // assert exists(Vf){d : d in nfd | IsWeaklyZero(qEigenform(d, l) - qexp)};
  // This is an example of where an intrinsic could be useful
  // The following 15 lines only check which space corresponds to qexp
  for d in nfd do
      f := qEigenform(d, l);
      Kf := BaseRing(Parent(f));
      K := BaseRing(Parent(qexp));
      is_sub, emb := IsSubfield(Kf, K);
      if is_sub then
          for sig in Automorphisms(Kf) do
	    sig_f := Parent(qexp)![(sig*emb)(c) : c in AbsEltseq(f)];
            if IsWeaklyZero(sig_f - qexp) then
	        Vf := d;
	        break d;
	    end if;
	  end for;
      end if;
  end for;
  pi := LocalComponent(Vf, 5);
  assert IsMinimal(pi);
  assert IsSupercuspidal(pi);
  assert Conductor(pi) eq 25;
  E, chi := AdmissiblePair(pi);
  ZZE := Integers(E);
  UE, mUE := UnitGroup(ZZE);
  zeta := chi(mUE(UE.2));
  min_poly := MinimalPolynomial(zeta);
  assert min_poly eq CyclotomicPolynomial(order);
  return;
end procedure;

procedure test_LW12_Ex2_all()
  data := [<50, 2, 3>, <25, 4, 6>, <50, 3, 8>, <25, 4, 12>, <25, 3, 24>];
  Qi<i> := QuadraticField(-1);
  _<x> := PolynomialRing(Qi);
  K<lambda> := ext<Qi | x^2 - 3*i>;
  K := AbsoluteField(K);
  _<q> := PowerSeriesRing(K);
  qexps := [
	    q - q^2 + q^3 + q^4 + O(q^5),
	    q + q^2 + 7*q^3 - 7*q^4 + O(q^5),
	    q + (i-1)*q^2 + (3*i+3)*q^3 - 2*i*q^4 + O(q^5),
	    q + i*q^2 - 7*i*q^3 + 7*q^4 + O(q^5),
	    q + lambda*q^2 + i*lambda*q^3 - i*q^4 + O(q^5)
	   ];
  for i->tup in data do
      N, k, order := Explode(tup);
      test_LW12_Ex2(N, k, qexps[i], order);
  end for;
  return;
end procedure;

test_LW12_Ex2_all();

exit;

// [LW12] D. Loeffler, J. Weinstein -
// On the computation of local components of a newform,
// Math. Comp. 81, 2012, 278, 1179--1200
