/********************************
 * Tests Bug report 72 
 ********************************/
procedure test_Bug_72()
  N := 6*13^2;
  Snew := NewSubspace(CuspidalSubspace(ModularSymbols(N,2,-1)));
  R := PolynomialRing(Rationals());
  Vf := Kernel([<5,R![1, -4, 3, 1]>,<7,R![-1, -4, -3, 1]>],Snew);
  f := qEigenform(Vf,1000);
  Kf := BaseRing(Parent(f));
  ZKf := Integers(Kf);
  pp7 := Factorization(7*ZKf)[1][1];
  k7, mk7 := ResidueClassField(pp7);
  assert {p+1-mk7(Coefficient(f,p)) : p in PrimesUpTo(1000)
      | N mod p ne 0} eq {0};
  pi := LocalComponent(Vf,13);
  assert IsMinimal(pi);
  assert IsSupercuspidal(pi);
  assert Conductor(pi) eq 169;
  E, chi := AdmissiblePair(pi);
  ZZE := Integers(E);
  UE, mUE := UnitGroup(ZZE);
  zeta := chi(mUE(UE.2));
  assert zeta^7 eq 1;
  return;
end procedure;

test_Bug_72();

exit;
