X040plus := X0NQuotient(40, [40]);
X040star := X0NQuotient(40, [5,8]);

assert not IsIsomorphic(X040plus, X040star);

assert Dimension(ModularCurveQuotient(117,[13])) eq 1;

// time X0NQuotient(146,[]); // 30.620

time E := X0NQuotient(96, [3,32]); // 0.190
time E := X0NQuotient(120, [3,5,8]); // 0.320

// tests from Sachi

triples := [<220,-117649/440, 3>,
            <75, 13997521/225, 8>,
            <126, 103823/63, 4>,
            <108, 9261/8, 3>,
            <150, -1/15, 4>,
            <68, 3048625/1088, 6>,
            <124, -35937/496, 4>,
            <63, 7189057/3969, 8>,
            <98, -15625/28, 6>,
            <84, -7189057/16128, 8>,
            <156, -2146689/1664, 7>,
            <140, 1367631/2800, 4>,
            <52, -2146689/1664, 7>,
            <80, 16384/5, 6>,
            <188, 3375/188, 2>,
            <132, 912673/528, 4>,
            <90, 357911/2160, 6>,
            <76, -1/608, 5>,
            <100, -121945/32, 5>, 
            <81, 0, 3>,
            <48, 35152/9, 8>,
            <64, 1728, 4>,
            <96, 2048/3, 4>,
            <72, 0, 6>];

for t in triples do
    time E := X0Nstar(t[1]);
    assert jInvariant(E) eq t[2];
    assert #MordellWeilGroup(E) eq t[3];
end for;

/* timings:
Time: 0.170
Time: 0.310
Time: 0.720
Time: 0.090
Time: 0.310
Time: 0.250
Time: 0.320
Time: 0.110
Time: 0.170
Time: 0.060
Time: 0.200
Time: 0.200
Time: 1.850
Time: 0.630
Time: 0.090
Time: 0.120
Time: 0.300
Time: 0.200
Time: 0.210
Time: 0.110
Time: 0.200
Time: 0.150
Time: 0.060
Time: 0.080
Time: 0.160
Time: 0.130
*/

