
// minred-demo2.m
// Some examples to test minimisation and reduction
// Version 22nd July 2008

SetVerbose("Reduction",1);
SetVerbose("Minimisation",2);
SetVerbose("QuarticReduce",0);

function AlternatingMatrix(seq)
  n := Integers()!((Sqrt(8*#seq + 1)+1)/2);
  r := [[i,j]: i,j in [1..n] | i lt j];
  assert #seq eq #r;
  R := Universe(seq);
  mat := Matrix(R,n,n,[<r[i][1],r[i][2],seq[i]>: i in [1..#seq]]);
  return mat - Transpose(mat);
end function;  

function GlobalLevel(phi)
  E := Jacobian(phi);
  _,iso := MinimalModel(E);
  u := IsomorphismData(iso)[4];
  if Degree(phi) eq 5 then 
    u := 6*u; 
  end if;
  return Integers()!(1/u);
end function;

models := [];

R<x,z> := PolynomialRing(Rationals(),2);
a := 2^10*7^50*11^50;
quartic := x^4 + x^3*z + a*z^4;
models cat:= [GenusOneModel(quartic)];

R<x,y,z> := PolynomialRing(Rationals(),3);
a := 2^50*3^50;
cubic := x*z^2 - y^3 + a*x^3;
models cat:= [GenusOneModel(cubic)];

R<x1,x2,x3,x4> := PolynomialRing(Rationals(),4);
a := 2^20*3^20;
quads := [x1*x4 - x2^2 + a*x1^2,x3^2-x2*x4];
models cat:= [GenusOneModel(quads)];

R<x1,x2,x3,x4,x5> := PolynomialRing(Rationals(),5);
a := 2^10*3^10;
entries := [x1,0,-x2,x3,-x2,a*x1 + x3,-x4,-x4,x5,0];
M := AlternatingMatrix(entries);
models cat:= [GenusOneModel(M)];

data2 := [
  [ 127749758596, 181394754320, 96587148768, 22857575840, 2028481168 ],
  [ 5749137, 10579896, -93054312, 121116384, -36577008 ],
  [ 34895618201600, -5840794096000, 366026160000, -10179100000, 106000000 ],
  [ 505398375000, 28571220000, 247424400, -4013280, 27864 ],
  [ 160926480, 92557080, 703299465, 192713400, 747892860 ],
  [ 73899264, 30827616, 3214992, 41988672274176, 34975379630592, 10925052794784,
    1516706950464, 78960632751 ],
  [ 257/31104, 3185/15552, 9731/5184, 117691/15552, 353101/31104 ],
  [ -52558831/1152, -12403459/144, -731779/18, -5188221730201/331776,
    -306088087027/5184, -577862222975/6912, -68183956399/1296, -1005657517/81 ]
];
models cat:= [GenusOneModel(Rationals(),2,seq): seq in data2];

data3 := [ 
  [ 497556464762880, 162041502414528, 10268388573321461760, -1173056830304256,
    -3840760196333568, 1678607125212672, 5610123270222336, 274066565984649216,
    460534337823707136, -20088600130363392 ],
  [ -9824585761916163, 68126171995037016, -3282191758509248907, 31868411157793602,
    -203319370477785681, 33722873769830364, 131765917553210556, 732975963983699751,
		     -3694046517636626718, 12988804750634916 ],
  [ 28955038541764903819475544619138285199338819461509187873356560511,
    39618019559632854369263685488611225741435100314745977963918043973,
    -458968979590448249902516523731269625442832275517092482341663031375,
    -97517846826283694830050386438559032941308482979005404999487692969,
    -107281347898002008541742056133884965747001105450125265549056140365,
    -101093374113833112618809893321078912676087000334135467704417166683,
    254900425192985519258953371764709666111814872383174289519746351115,
    -282882023880265778731678970629127749029499925406390773649330504675,
    469606487274775848382233663870962706530732563829909885996152574775,
    159415944809129679724917858426400754036592236718520430393526731890 ],
  [ -8937825002/6302625, -27404770553/50421000, 13/10890936000, -12985019501/4201750,
    43164713/75631500, -56592907283/25210500, 92373019/302526000, -1541/302526000,
    -6479/1815156000, 63143503/75631500 ]
];
models cat:= [GenusOneModel(Rationals(),3,seq): seq in data3];

data4 := [
  [ 13652750, -21717600, -97146220, -6190080, 4226450, 34237425, 3369820, 
    68321886, 13942916, 698224, 11699500, 3380800, 21003560, -127360, 
    -505100, -3244950, -889960, -3796788, -3696088, -268192 ],
  [ -819372800, 476378703360, 61815446400, -98324480, -8526746714112, 
    -5724767676672, 1700515249920, -609209301440, 203402800384, 7518225920, 
    -308276300, 179231974560, 23257310400, -36972080, -3208095605952, 
    -2153880093312, 639799384320, -229208124740, 76527879064, 2828678120 ],
  [ 887849821, 18464937898, 17670037393, 4794279681, -3707351444, -10793249758, 
    -16549154436, -8541181439, 26591354349, -26208015021, 5137616434, 
    -32208847946, 21708873897, -4131978193, 97149092, 36193852526, 19001977684, 
    19025504874, 18905580283, -2621965935 ],
  [ 18582, 2631, -154374, 7272, -48, -10806, -3636, 320892, -28152, -12096, 
    99386, 13813, -824402, 15096, -184, -56738, -20508, 1711316, -53736, -42048 ],
  [ 541487201856, -14962251120, -2111263152, -3266070768, 10716360, 50593440, 
    -33821496, 2253696, 13364568, -11087280, 96967728384, -2679386496, -378077568, 
		-584876160, 1919040, 9060096, -6056640, 403584, 2393280, -1985472 ],
  [ 1199/144, -41/48, 278/9, 1469/288, -30025/2916, 1484/81, 39095/324, 111/4,
    -46639/432, -101807/288, 49/12, -23/4, 89/6, 271/8, -1532/243, 229/27, 
    3991/54, 14, -1799/36, -15595/72 ]
];
models cat:= [GenusOneModel(Rationals(),4,seq): seq in data4];

data5 := [
   [ -170/21, 31/252, -796/63, 508/441, 9/7, -121/42, 1/14, -193/42, -61/441, 
     115/252, -44/21, 11/336, -23/7, 37/147, 1/3, -109/9, 1231/2016, -5147/252,
     -3959/588, 40/21, -2131/6, 227/32, -3341/6, 187/7, 337/6, -302, 173/48, 
     -1403/3, 1331/21, 48, -65821/12, 63059/576, -309569/36, 52225/126, 10409/12, 
     -5, 43/48, -37/3, -839/42, 5/6, -102263/72, 98039/3456, -480983/216, 
     20200/189, 4043/18, -4523/4, 331/576, -15121/9, 70835/126, 1433/8 ],
   [ 513240, -16380000, 66003840, 1365000, -140197680, -68432, 5264168, 55526016,
     273000, -111325032, 1820, 10738, 112476, 546, -225498, -3976336, -58058832,
     196751952, 4436432, -420961152, 0, 0, 80640, 0, -161280, 109200, -3407040, 
     13728960,283920, -29161440, -6988800, -1485120, 20966400, 262080, -43243200, 
     -14560, 1094912,11548992, 56784, -23154768, 926016, 693056, 6370560, 23296, 
     -12741120, 820820, 12077728, -40912224, -922740, 87535608 ],
   [ -31026, 7064, 13927040, -42403854, 256, 7134, 4536, -3162240, 9629628, -216, -18144, -17056, 8042240,
      -24492528, 736, -2098, -5172, 950080, -2894836, 132, 1266, -711, -607200, 1849893, 
      -9, -4556, 3096, 2198400, -6696908, 24, -1012, 537, 486000, -1479841,3, 300, 0, -144000, 
      438600, 0, 150, 0, -70800, 215520, 0, -300, 0, 140800, -428520, 0 ],
   [ -245520, -8365200, 2070450, 38730, -35400, 21808, 776080, -191840, -576, 4480, 2140920, 75947400, 
     -18793530, -281646, 358920, -1034475, -34767945, 8607810, 193488, -134760, 1166640, 39721200, -9831450,
     -185970, 167400, 10669860, 361543500, -89487450, -1723410, 1506600, 3429450, 116491950, -28834200, 
     -561555, 486000, 9227592, 327148920, -80964450, -1326438, 1506600, -5220183, -175900845, 43545930, 
     937392, -698760, -74884905, -2561037075, 633952170, 12686031, -10662840 ],
   [ 20804970751773973214052328899360767987786482669743,
     2960804385605479797655220785403570886215325683214,
     -12216986031580958950878735839083146986921090322693,
     14177961368797597603182491309155885799413314328873,
     4192807653786971595917989301213464318512397656127,
     14814114129760082515285061678918270498582087454483,
     -8375771179555200153381435662010910337691174564300,
     701575224700354155324532164208596494224807940273,
     4145811975639398320814698626882324927722813418638,
     6487256138240907621718011797104964713266666920595,
     4509458691130945524370602737075549141332901570598,
     -4615088507671307186237991042542444054090567452827,
     2065605662997323867241768565926529083555392632656,
     89859007753054409985202508130458181164942905278,
     2664633947394825401825692133492289380003688404994,
     -5382174729615196362938875195774008861077186222199,
     9300881399987994442552843208606949202977280129665,
     -5866086277483045086280206974217026103307847479079,
     2045030532096229745257091939562426517800203704336,
     -4447105463883272112459556498851076764775769882715,
     -14101891462352886798462971472454924517064986154288,
     -3215699363576128109217114879974521573856211831202,
     1333344834879838053759237185193161858694834022254,
     213563155188284677103697078184145339343007319739,
     5510643369179867742589631315645005450928437425640,
     -4284559315182415992650349774603881338199968839324,
     -1215869666385611760106163522122056696743494623579,
     -967623892877618622391995936002742538070321843832,
     2005894771606361353997958042298342334386050204999,
     3324651231342955305873552737761108307553872577312,
     -701050533830899637978040584679971082144641393454,
     1060957161366224389741919214515702427377091120922,
     7082711999081811769989100193772434139848686485396,
     -9910430405256120530638847915895936462332698178885,
     -8161507805164622264851964940049350838897623132342,
     5765272486300670488168200812425028615426400699,
     -1572846585136962842614781669181639712779494462886,
     281004298675032179201977894643716440392180085945,
     585194992210923033610671406179114373359412242540,
     1641863229361169973984023137854823607842340732115,
     -4147291890809074504311872699442477733701901668933,
     7100267780583368180244721468766371046127999308445,
     -1046949801548561370373126742069169196234518301543,
     -2928737295202829872179514069902002382701372416033,
     -6782896263814230675850405393034507236884929241945,
     -1260352903605120315953691451148404656118589876451,
     2165711586188229410935227230508068467246027763169,
     -732907834367857348348254742523126190224360059611,
     -352142128537386107273174824256323807821974013528,
     -1660547460809353812751410568284763227202027370559 ]
];
models cat:= [GenusOneModel(Rationals(),5,seq): seq in data5];

insoldata := [{},{},{},{},{},{},{},{},{3,11},{},{},{},
    {},{},{2,7},{},{},{},{2},{3},{2,3},{},{},{7,13},{},{},{}];

finallist := [];

for ctr in [1..#models] do
  phi := models[ctr];
  printf "\nExample number %o \n",ctr;
  phimin,tr,insol := Minimise(phi); // :Transformation:=false);
  assert phimin eq tr*phi;
  if Degree(phi) eq 2 then 
    assert insol subset insoldata[ctr] join {2};
    phired,tr := Reduce(phimin : Minkowski);
    assert phired eq tr*phimin;
    print Eltseq(phired);
    finallist cat:= [phired];
    phimin,tr,insol := Minimise(phi:CrossTerms);
    assert phimin eq tr*phi;
  end if;
  pp := Factorization(GlobalLevel(phimin));
  assert {p[1]: p in pp} eq insol;
  assert insol eq insoldata[ctr];
  phired,tr := Reduce(phimin : Minkowski);
  assert phired eq tr*phimin;
  print Eltseq(phired);
  finallist cat:= [phired];
end for;

/*
n := 5;
while true do
  sz := Random([10..200]);
//  phi := RandomTransformation(n:Size:=sz,Unimodular)*RandomModel(n);
  phi := RandomTransformation(n:Size:=sz)*RandomModel(n);
  phi1,tr1 := Minimise(phi);
  assert tr1*phi eq phi1;
  phi2,tr2 := Reduce(phi1 : Minkowski);
  assert tr2*phi1 eq phi2;
  print Eltseq(phi2);
  SetOutputFile("mylog");
  print Eltseq(phi2);
  UnsetOutputFile();
end while;
*/

