procedure test_bug_Jan_28()
    R<x> := PolynomialRing(Rationals());
    K<a> := NumberField(x^4 - x^3 - 5*x^2 + 2*x + 4);
    assert not IsNormal(K);
    autK := AutomorphismGroup(K);
    assert #autK eq 2;
end procedure;

procedure test_field_random(K)
    G, _, phi := AutomorphismGroup(K);
    g := Random(G);
    sig := phi(g);
    assert sig@@phi eq g;
end procedure;

procedure test_field_all(K)
    G, _, phi := AutomorphismGroup(K);
    // printf "#G = %o\n", #G;
    for g in G do
        sig := phi(g);
        assert sig@@phi eq g;
    end for;
end procedure;

procedure test_field(K : use_random := false)
    if (use_random) then
        test_field_random(K);
    else   
        test_field_all(K);
    end if;
end procedure;

procedure test_random_number_field( : min_deg := 1, max_deg := 20, max_coeff := 1000, use_random := false)
    _<x> := PolynomialRing(Rationals());
    deg := Random([min_deg..max_deg]);
    // printf "deg = %o\n", deg;
    repeat
        f := &+[Random([-max_coeff..max_coeff])*x^i : i in [0..deg-1]] + x^deg;
    until IsIrreducible(f);
    K := NumberField(f);
    test_field(K : use_random := use_random);
end procedure;

procedure test_random_finite_field( : min_deg := 1, max_deg := 20, prime_bound := 1000, use_random := false)
    deg := Random([min_deg..max_deg]);
    p := Random(PrimesUpTo(prime_bound));
    K := GF(p^deg);
    test_field(K : use_random := use_random);
end procedure;

procedure test_rationals()
    test_field(Rationals());
end procedure;

procedure test_quadratic_field(D)
    K := QuadraticField(D);
    test_field(K);
end procedure;

procedure test_not_normal()
    _<x> := PolynomialRing(Rationals());
    K := NumberField(x^3 - 2);
    test_field(K);
end procedure;

ds := [d : d in [1..10000] | IsFundamentalDiscriminant(d)];
for i in [1..10] do
    d := Random(ds);
    test_quadratic_field(d);
end for;

test_rationals();

test_not_normal();

for i in [1..10] do
    test_random_number_field();
end for;

for i in [1..10] do
    test_random_finite_field();
end for;

test_bug_Jan_28();