/********************************
 * Tests Example 3 from [LW12]
 ********************************/
procedure test_LW12_Ex3()
  // Create the corresponding space of modular symbols
  ms := ModularSymbols(81);
  Snew := NewSubspace(CuspidalSubspace(ms));
  nfd := NewformDecomposition(Snew);
  assert #nfd eq 1;
  Vf := nfd[1];
  Kf := HeckeEigenvalueField(Vf); 
  pi := LocalComponent(Vf, 3);
  assert IsMinimal(pi);
  assert IsSupercuspidal(pi);
  assert Conductor(pi) eq 81;
  E, chi := AdmissiblePair(pi);
  Ex<x> := PolynomialRing(E);
  alpha := Roots(x^2-x+2, E)[1][1];
  zeta := chi(alpha);
  assert IsSubfield(Kf, Parent(zeta));
  min_poly<x> := MinimalPolynomial(zeta, Kf);
  is_sqr, sqrt3 := IsSquare(Kf!3);
  assert is_sqr;
  assert (min_poly eq x^2 + sqrt3*x + 1) or (min_poly eq x^2 - sqrt3*x + 1);
  return;
end procedure;

test_LW12_Ex3();

exit;

// [LW12] D. Loeffler, J. Weinstein -
// On the computation of local components of a newform,
// Math. Comp. 81, 2012, 278, 1179--1200
