/********************************
 * Tests Example 1 from [LW12]
 ********************************/
import !"Geometry/ModSym/operators.m" : ActionOnModularSymbolsBasis;

procedure test_LW12_Ex1()
  // Create the corresponding space of modular symbols
  // Note that H has order EulerPhi(50)/EulerPhi(5) = 5
  msH := ModularSymbolsH(50, 5, 2, 0);
  // Note that [LW12] assert erroneously that dim of cuspidal subspace is 31
  assert Dimension(msH) eq 31;
  index := &+[Degree(BaseRing(m)) : m in MultiSpaces(msH)] * msH`mlist`n;
  assert index eq 360;
  Snew := NewSubspace(CuspidalSubspace(msH));
  R<T> := PolynomialRing(Rationals());
  // cutting out the Hecke subspace corresponding to f (50.2.a.a) 
  V_f := Kernel([<2, T+1>, <3, T-1>], Snew);
  // Verifying that a_5(f) = 0
  assert V_f subset Kernel([<5, T>], Snew);
  assert Dimension(V_f) eq 2;
  // Directly calling LocalComponent yields an error - todo: fix that
  // replacing V_f by a modular symbols space obtained from
  // newform decomposition
  nfd := NewformDecomposition(Snew);
  assert exists(Vf){d : d in nfd | VectorSpace(V_f) eq VectorSpace(d)};
  // This is sigma_f_plus from the paper
  star := StarInvolution(msH);
  sigma_f_plus := Basis(Kernel(star - 1) meet VectorSpace(Vf))[1];
  // R is the element in step 3, generating the twist space Xf_plus
  R := ActionOnModularSymbolsBasis([1,1/5,0,1], msH);
  // Checking that Xf_plus is 4-dimensional, spanned by repeatedly applying R
  Xf_basis := [sigma_f_plus*R^i : i in [0..3]];
  Xf_plus := sub<Universe(Xf_basis) | Xf_basis>;
  assert Xf_plus*R eq Xf_plus;
  // Using the description in 4.3, rho([0,-1,1,0]) is obtained by setting
  // alpha = [5,4,6,5], and conjugating by [5,0,0,1], yielding the element below
  S := ActionOnModularSymbolsBasis([5,4/5,30,5], msH);
  assert Xf_plus*S eq Xf_plus;
  // Verifying that Xf_plus is contained in the intersection of the kernels
  // of the two degeneracy maps to level 10, so f is 5-primitive.
  assert Xf_plus subset VectorSpace(Snew);
  // Following step 5, myA1, myA2 are rho([1,1,0,1]) and rho([0,-1,1,0])
  myA1 :=  Transpose(Solution(Matrix(Xf_basis), Matrix(Xf_basis)*R));
  myA2 :=  Transpose(Solution(Matrix(Xf_basis), Matrix(Xf_basis)*S));
  // A1 and A2 are the matrices obtained in the paper
  // by a differnet choice of basis
  QQ := Rationals();
  A1 := Matrix(QQ, [[1,0,0,-1],[0,0,-1,0],[-1,1,-2,1],[1,0,-1,0]]);
  A2 := Matrix(QQ, [[-1,1,-2,1],[0,0,-1,0],[0,-1,0,0],[0,-1,-1,1]]);
  // We check for the existence of a change of basis matrix conjugating both
  // A1 and A2 to myA1 and myA2
  // We do that by solving the relevant linear equations
  QQx<[x]> := PolynomialRing(QQ, 16);
  A1x := ChangeRing(A1, QQx);
  A2x := ChangeRing(A2, QQx);
  myA1x := ChangeRing(myA1, QQx);
  myA2x := ChangeRing(myA2, QQx);
  X := MatrixAlgebra(QQx,4)!x;
  eqs := Eltseq(A1x*X - X*myA1x) cat Eltseq(A2x*X-X*myA2x);
  mat := Matrix(QQ, [[Coefficient(e, i, 1) : e in eqs] : i in [1..16]]);
  ker := Kernel(mat);
  // Since there are no scalar matrices commuting with both A1 and A2,
  // (Xf_plus is an irreducible representation), the space of solutions
  // should be one-dimensional
  assert Dimension(ker) eq 1;
  cob := MatrixAlgebra(QQ,4)!Eltseq(Basis(ker)[1]);
  assert (cob^(-1)*A1*cob eq myA1) and (cob^(-1)*A2*cob eq myA2);
  // Proceeding to Step 6
  // Checking that the change of basis matrix also conjugates the matrices
  // found in this step to the ones int the paper
  // Here 3 = 2^(-1) mod 5 and the matrix below is delta_3 g delta_3^(-1)
  // with g = [1,1/5,0,1]
  conj_R := ActionOnModularSymbolsBasis([1,3/5,0,1], msH);
  myA1prime := Transpose(Solution(Matrix(Xf_basis), Matrix(Xf_basis)*conj_R)); 
  A1prime := Matrix(QQ, [[-2,1,-1,1],[-2,2,-2,1],[-1,2,-1,0],[-2,2,-1,0]]);
  assert cob^(-1)*A1prime*cob eq myA1prime;
  // Similarly this is delta_3 delta_3^(-1) with g = [5,4/5,30,5]
  conj_S := ActionOnModularSymbolsBasis([5,12/5,10,5], msH);
  myA2prime := Transpose(Solution(Matrix(Xf_basis), Matrix(Xf_basis)*conj_S));
  A2prime := Matrix(QQ, [[-1,2,-1,0],[0,1,0,0],[0,0,1,0],[0,1,1,-1]]);
  assert cob^(-1)*A2prime*cob eq myA2prime;
  // Finding lambda_2 (corresponding to B in the paper),
  // as the solution of A_i*x = x A_i'
  // Note that there is a typo in the paper, reversing the multiplication
  A1primex := ChangeRing(A1prime, QQx);
  A2primex := ChangeRing(A2prime, QQx);
  eqs := Eltseq(A1x*X - X*A1primex) cat Eltseq(A2x*X-X*A2primex);
  mat := Matrix(QQ, [[Coefficient(e, i, 1) : e in eqs] : i in [1..16]]);
  ker := Kernel(mat);
  assert Dimension(ker) eq 1;
  B :=  [ 1, -2, 1, 0, 0, -1, 0, 1, 0, 0, -1, 1, 0, -1, -1, 1 ];
  assert Eltseq(Basis(ker)[1]) eq B;
  pi := LocalComponent(Vf, 5);
  assert IsMinimal(pi);
  assert IsSupercuspidal(pi);
  assert Conductor(pi) eq 25;
  // Verifying the characeter of rho agrees with the computation in the paper
  W := CuspidalInducingDatum(pi);
  rho := Representation(W);
  reps := [[1,0,0,1],[2,0,0,1],[4,0,0,1],[1,1,0,1],[0,2,1,0],
		    [0,1,1,2],[0,2,1,2]];
  traces := [4,0,0,-1,-2,1,1];
  assert &and[Character(rho)(reps[i]) eq traces[i] : i in [1..#reps]];
  E, chi := AdmissiblePair(pi);
  ZZE := Integers(E);
  UE, mUE := UnitGroup(ZZE);
  zeta := chi(mUE(UE.2));
  min_poly := MinimalPolynomial(zeta);
  // Verifying tha the character has order 3
  assert min_poly eq T^2 + T + 1;
  return;
end procedure;

test_LW12_Ex1();

exit;

// [LW12] D. Loeffler, J. Weinstein -
// On the computation of local components of a newform,
// Math. Comp. 81, 2012, 278, 1179--1200
