/////////// Test polynomials for the Monthes algorithm //////////////////
// can be found in https://arxiv.org/pdf/1104.3181.pdf
// GUARDIA20121318 in magma.bib


///////////////////////////////////////////////////////
///////////////////////////////////////////////////////


// Type 1: one totally ramified primes over p

Apnk := function(p,n,k,r)

Fqt:=Parent(p);

KxT<x> := PolynomialRing(Fqt);

f:=(x+&+[p^i:i in [0..r]])^n+p^k;
//print"f",f;
if not Type(Generators(Fqt)) eq Type([]) then

return    FunctionField(f);
end if;    


return NumberField(f);

end function;


/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////


// Type 2: prime splits

Ampnk := function(m,p,n,k,r)

Fqt:=Parent(p);

KxT<x> := PolynomialRing(Fqt);

f:=&*[(x^n+2*i)+2*p^k:i in [0..m-1]] +2*p^(m*n*k);

//print"f",f;
if not Type(Generators(Fqt)) eq Type([]) then

return    FunctionField(f);
end if;    


return NumberField(f);

end function;


/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////


// Type 3: prime splits into two prime ideals

Bpk := function(p,k)

Fqt:=Parent(p);

KxT<x> := PolynomialRing(Fqt);

f:=(x^2-2*x+4)^3+p^k;

//print"f",f;
if not Type(Generators(Fqt)) eq Type([]) then

return    FunctionField(f);
end if;    


return NumberField(f);

end function;




/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////




// Type 4: 6 primes over p


Cpk := function(p,k)

Fqt := Parent(p);

if not Type(Generators(Fqt)) eq Type([]) then

    t:=Fqt.1;
end if;    

KxT<x> := PolynomialRing(Fqt);

f := ((x^6+4*p*x^3+3*p^2*x^2+4*p^2)^2+p^6)^3+p^k;
//print"f",f;

if not Type(Generators(Fqt)) eq Type([]) then

 return   FunctionField(f);
end if;    



return NumberField(f);

end function;



/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////


// Type 5: prime splits 

Dlpnk := function(l,p,n,k)

Fqt:=Parent(p);

KxT<x> := PolynomialRing(Fqt);

f:=(&+[x^j:j in [0..l-1]])^n +p^k;

//print"f",f;
if not Type(Generators(Fqt)) eq Type([]) then

return    FunctionField(f);
end if;    


return NumberField(f);

end function;



///////////////////////////////////////////////////////
///////////////////////////////////////////////////////


// Type 6: one totally ramified prime

Epk := function(p,k)

Fqt := Parent(p);
/*if not Type(Generators(Fqt)) eq Type([]) then

    t:=Fqt.1;
end if;    
*/
KxT<x> := PolynomialRing(Fqt);


E1:=x^2+p;
E2:=E1^2+(p-1)*p^3*x;
E3:=E2^3+p^11;
E4:=E3^3+p^29*x*E2;
E5:=E4^2+(p-1)*p^42*x*E1*E3^2;
E6:=E5^2+p^88*x*E3*E4;
E7:=E6^3+p^295*E2*E4*E5;
E8:=E7^2+(p-1)*p^632*x*E1*E2^2*E3^3*E6;

L:=[E1,E2,E3,E4,E5,E6,E7,E8];
//print"f:=",L[k];
if not Type(Generators(Fqt)) eq Type([]) then

 return   FunctionField(L[k]);
end if;    


return NumberField(L[k]);

end function;

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////


// Type 7: Einsenstein polynomials 

Eisen := function(p,n,k)

Fqt:=Parent(p);

KxT<x> := PolynomialRing(Fqt);

f := x^n+&+[x^i*p^Random([1..k]):i in [1..n-1]]+p-1;

//print"f",f;
if not Type(Generators(Fqt)) eq Type([]) then

return    FunctionField(f);
end if;    


return NumberField(f);

end function;

