////////////////
//
// Test code for interface.m
//
////////////////


// Split quaternion algebra, the forgetful map
A := AssociativeAlgebra(QuaternionAlgebra<Rationals() | -1,1>);
A;

// A nontrivial right ideal
M := rideal<A | A.3-1>;
// Returns the 2x2 matrix ring
MA, phi := MatrixAlgebra(A,M);
MA;
phi;

// Trivially returns true and a map to a quaternion algebra 
// (basis is already in standard form)
bl, Aquat, phi := IsQuaternionAlgebra(A);
bl;

// We create a "random" sequence of 4 elements of A, and see if we can
// recover A (or an isomorphic algebra)
repeat
    vecs := [&+[Random(10)*A.i : i in [1..4]] : j in [1..4]];
    Mchange := Matrix(Rationals(),4,4,&cat[Eltseq(vecs[i]) : i in [1..4]]);
until IsUnit(Mchange);
Mchange := Mchange^(-1);
A := AssociativeAlgebra<Rationals(),4 | [<i,j,k,((vecs[i]*vecs[j])*Mchange)[k]> : 
                        i,j,k in [1..4]] : Rep := "Dense">;
bl, Aquat, phi := IsQuaternionAlgebra(A);
bl; 
Aquat;
Aquat.1^2, Aquat.2^2;
phi;

// Verify the functionality when a zerodivisor is encountered.
A := Algebra(MatrixAlgebra(Rationals(),2));
IsQuaternionAlgebra(A);

// Verify correct output (false!) for a nonsemisimple algebra, 
//   k<x,y | x^2, y^2, x*y+y*x>.
// (The ideal generated by x,y is a nontrivial two-sided ideal.)
A := Algebra(FPAlgebra<Rationals(), x,y | x^2, y^2, x*y+y*x>);
A;
IsQuaternionAlgebra(A);

// Verify correct output (false!) for a commutative algebra
A := Algebra(FPAlgebra<Rationals(), x | x^4+x^2+1>);
A;
IsQuaternionAlgebra(A);

// Check characteristic 2
A := Algebra(FPAlgebra<GF(2), x,y | x^2, y^2, x*y+y*x+1>);
A;
IsQuaternionAlgebra(A);

A := Algebra(FPAlgebra<GF(2), x,y | x^2+x+1, y^2+1, y*x+(x+1)*y>);
A;
IsQuaternionAlgebra(A);
